/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.builders.accumulators;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.builders.accumulators.BuilderAccumulator;
import java.util.List;

public class NumberAccumulator
extends BuilderAccumulator {
    private int count = 0;
    private double sum = 0.0;
    private double min = Double.MAX_VALUE;
    private double max = Double.MIN_VALUE;

    public NumberAccumulator(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Object value) {
        if (value == null) {
            return;
        }
        NumberAccumulator numberAccumulator = this;
        synchronized (numberAccumulator) {
            ++this.count;
            this.sum += ((Double)value).doubleValue();
            this.min = Math.min(this.min, (Double)value);
            this.max = Math.max(this.max, (Double)value);
        }
    }

    @Override
    public List<Cube.Indicator> indicators() {
        return List.of(Cube.indicator("_count(" + this.name + ")", this.count), Cube.indicator("_ratio(" + this.name + ")", (double)this.count / (double)this.total), Cube.indicator("_sum(" + this.name + ")", this.sum), Cube.indicator("_avg(" + this.name + ")", this.count > 0 ? this.sum / (double)this.count : 0.0), Cube.indicator("_min(" + this.name + ")", this.min), Cube.indicator("_max(" + this.name + ")", this.max));
    }
}

