/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine.builders;

import io.intino.sumus.engine.Cube;
import io.intino.sumus.engine.Fact;
import io.intino.sumus.engine.Filter;
import io.intino.sumus.engine.Slice;
import io.intino.sumus.engine.builders.Accumulator;
import io.intino.sumus.engine.filters.SliceFilter;
import io.intino.sumus.engine.parser.IndicatorDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CellBuilder {
    public final List<IndicatorDefinition> indicators;
    public final Filter filter;
    public final List<Slice> slices;
    public final List<Accumulator> accumulators;

    public CellBuilder(List<IndicatorDefinition> indicators) {
        this.indicators = indicators;
        this.filter = Filter.None;
        this.slices = Collections.emptyList();
        this.accumulators = new ArrayList<Accumulator>();
    }

    public CellBuilder(List<IndicatorDefinition> indicators, List<Slice> slices) {
        this.indicators = indicators;
        this.filter = SliceFilter.of(slices);
        this.slices = slices;
        this.accumulators = new ArrayList<Accumulator>();
    }

    public void add(Accumulator accumulator) {
        this.accumulators.add(accumulator);
    }

    public void add(Fact fact) {
        boolean isAccepted = this.filter.accepts(fact.idx());
        for (Accumulator accumulator : this.accumulators) {
            accumulator.add();
            if (!isAccepted) continue;
            accumulator.add(fact.value(accumulator.name()));
        }
    }

    public String toString() {
        return this.slices.stream().map(Slice::name).collect(Collectors.joining("-"));
    }

    public Cube.Cell cell(final Iterable<Fact> facts) {
        return new Cube.Cell(){

            @Override
            public List<Slice> slices() {
                return CellBuilder.this.slices;
            }

            @Override
            public List<Cube.Indicator> indicators() {
                return this.translate(this.calculations());
            }

            private List<Cube.Indicator> translate(Map<String, Cube.Indicator> calculations) {
                return CellBuilder.this.indicators.stream().map(d -> calculations.getOrDefault(d.formula, Cube.Indicator.None).as(d.name, d.units, d.ratio)).collect(Collectors.toList());
            }

            private Map<String, Cube.Indicator> calculations() {
                return CellBuilder.this.accumulators.stream().flatMap(a -> a.indicators().stream()).collect(Collectors.toMap(Cube.Indicator::name, i -> i));
            }

            @Override
            public Iterable<Fact> facts() {
                return facts;
            }

            public String toString() {
                return CellBuilder.this.slices.stream().map(Object::toString).collect(Collectors.joining("-"));
            }
        };
    }
}

