/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.engine;

import io.intino.sumus.engine.parser.AttributeDefinition;
import io.intino.sumus.engine.parser.DimensionDefinition;
import java.util.Objects;

public class Attribute {
    public static Attribute Null = new Attribute("null", Type.label, false, new DimensionDefinition[0]);
    public final String name;
    public final Type type;
    public final boolean isUsedInIndicators;
    public final DimensionDefinition[] dimensions;

    public Attribute(String name, Type type, boolean isUsedInIndicators, DimensionDefinition ... dimensions) {
        this.name = name;
        this.type = type;
        this.isUsedInIndicators = isUsedInIndicators;
        this.dimensions = dimensions;
    }

    public Attribute(AttributeDefinition definition) {
        this(definition.name, definition.type, definition.isUsedInIndicators, definition.dimensions.toArray(new DimensionDefinition[0]));
    }

    public boolean isNumeric() {
        return this.type.isNumeric();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this == o || this.equals((Attribute)o);
    }

    private boolean equals(Attribute attribute) {
        return Objects.equals(this.name, attribute.name) && this.type == attribute.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type});
    }

    public String toString() {
        return this.name;
    }

    public static enum Type {
        key,
        label,
        number,
        integer,
        category,
        date,
        url;


        public boolean isNumeric() {
            return this == number || this == integer;
        }

        public boolean isOrdinal() {
            return this.isNumeric() || this == date;
        }
    }
}

