/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos.filters;

import io.intino.sumus.chronos.Filter;
import smile.wavelet.BestLocalizedWavelet;
import smile.wavelet.CoifletWavelet;
import smile.wavelet.D4Wavelet;
import smile.wavelet.DaubechiesWavelet;
import smile.wavelet.HaarWavelet;
import smile.wavelet.SymletWavelet;
import smile.wavelet.Wavelet;
import smile.wavelet.WaveletShrinkage;

public class Denoise
implements Filter {
    private final Mode mode;

    public Denoise(Mode mode) {
        this.mode = mode;
    }

    @Override
    public double[] calculate(double[] values) {
        double[] result = (double[])values.clone();
        WaveletShrinkage.denoise((double[])result, (Wavelet)this.mode.wavelet);
        return result;
    }

    public static enum Mode {
        D4((Wavelet)new D4Wavelet()),
        Haar((Wavelet)new HaarWavelet()),
        Coiflet6((Wavelet)new CoifletWavelet(6)),
        Coiflet12((Wavelet)new CoifletWavelet(12)),
        Coiflet18((Wavelet)new CoifletWavelet(18)),
        Coiflet24((Wavelet)new CoifletWavelet(24)),
        Coiflet30((Wavelet)new CoifletWavelet(30)),
        Daubechies4((Wavelet)new DaubechiesWavelet(4)),
        Daubechies6((Wavelet)new DaubechiesWavelet(6)),
        Daubechies8((Wavelet)new DaubechiesWavelet(8)),
        Daubechies10((Wavelet)new DaubechiesWavelet(10)),
        Daubechies12((Wavelet)new DaubechiesWavelet(12)),
        Daubechies14((Wavelet)new DaubechiesWavelet(14)),
        Daubechies16((Wavelet)new DaubechiesWavelet(16)),
        Daubechies18((Wavelet)new DaubechiesWavelet(18)),
        Daubechies20((Wavelet)new DaubechiesWavelet(20)),
        Symlet8((Wavelet)new SymletWavelet(8)),
        Symlet10((Wavelet)new SymletWavelet(10)),
        Symlet12((Wavelet)new SymletWavelet(12)),
        Symlet14((Wavelet)new SymletWavelet(14)),
        Symlet16((Wavelet)new SymletWavelet(16)),
        Symlet18((Wavelet)new SymletWavelet(18)),
        Symlet20((Wavelet)new SymletWavelet(20)),
        BestLocalized14((Wavelet)new BestLocalizedWavelet(14)),
        BestLocalized18((Wavelet)new BestLocalizedWavelet(18)),
        BestLocalized20((Wavelet)new BestLocalizedWavelet(20));

        private final Wavelet wavelet;

        private Mode(Wavelet wavelet) {
            this.wavelet = wavelet;
        }
    }
}

