/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos;

import io.intino.sumus.chronos.Magnitude;
import io.intino.sumus.chronos.MeasurementBuffer;
import io.intino.sumus.chronos.TimelineStore;
import io.intino.sumus.chronos.timelines.blocks.SensorModel;
import java.util.Collection;
import java.util.Map;

public class MeasurementsVector {
    private final TimelineStore.SensorModel sensorModel;
    private final double[] values;

    public static MeasurementsVector of(Map<String, Number> measurements) {
        return new MeasurementsVector(measurements.keySet()).set(measurements);
    }

    public MeasurementsVector(Collection<String> magnitudes) {
        this(new SensorModel((String[])magnitudes.toArray(String[]::new)));
    }

    public MeasurementsVector(String ... magnitudes) {
        this(new SensorModel(magnitudes));
    }

    public MeasurementsVector(Magnitude ... magnitudes) {
        this(new SensorModel(magnitudes));
    }

    public MeasurementsVector(TimelineStore.SensorModel sensorModel) {
        this.sensorModel = sensorModel;
        this.values = new double[sensorModel.size()];
    }

    public MeasurementsVector set(Map<String, Number> measurements) {
        measurements.forEach((magnitude, value) -> this.set((String)magnitude, value.doubleValue()));
        return this;
    }

    public MeasurementsVector set(String magnitude, MeasurementBuffer buffer) {
        return this.set(magnitude, buffer.reduce());
    }

    public MeasurementsVector set(String magnitude, double value) {
        this.values[this.sensorModel.indexOf((String)magnitude)] = value;
        return this;
    }

    public TimelineStore.SensorModel sensorModel() {
        return this.sensorModel;
    }

    public double[] toArray() {
        return this.values;
    }
}

