package io.intino.sumus.chronos.timelines.stores;

import io.intino.sumus.chronos.Timeline;
import io.intino.sumus.chronos.TimelineImpl;
import io.intino.sumus.chronos.TimelineStore;
import io.intino.sumus.chronos.Timelines;

import java.io.IOException;
import java.nio.channels.SeekableByteChannel;

import static io.intino.sumus.chronos.timelines.TimelineReader.*;

public abstract class AbstractTimelineStore implements TimelineStore {

	private Header header;
	private SensorModel sensorModel;
	private TimeModel timeModel;

	protected void init() throws IOException {
		try(SeekableByteChannel channel = openChannel()) {
			this.header = readHeader(channel);
			this.sensorModel = readSensorModel(header.sensorModelPosition(), channel);
			this.timeModel = readTimeModel(header.timeModelPosition(), channel);
		}
	}

	@Override
	public Timeline timeline() throws IOException {
		return Timelines.read(openChannel());
	}

	@Override
	public Header header() {
		return header;
	}

	@Override
	public SensorModel sensorModel() {
		return sensorModel;
	}

	@Override
	public TimeModel timeModel() {
		return timeModel;
	}

	protected abstract SeekableByteChannel openChannel() throws IOException;
}
