package io.intino.sumus.chronos.models.descriptive.sequence;

import java.util.Arrays;

public class Histogram {
	public final String[] symbols;
	public final int[] count;
	public final int total;

	private Histogram(Sequence sequence) {
		this.symbols = sequence.symbols();
		this.count = new int[this.symbols.length];
		this.total = sequence.length();
	}

	public static Histogram of(Sequence sequence) {
		Histogram histogram = new Histogram(sequence);
		for (Sequence.Point point : sequence)
			histogram.count[point.token()]++;
		return histogram;
	}

	@Override
	public String toString() {
		return Arrays.toString(count);
	}


}
