package io.intino.sumus.chronos.filters;

import io.intino.sumus.chronos.Filter;
import smile.wavelet.*;

public class Denoise implements Filter {
	public enum Mode {
		D4(new D4Wavelet()),
		Haar(new HaarWavelet()),
		Coiflet6(new CoifletWavelet(6)), Coiflet12(new CoifletWavelet(12)), Coiflet18(new CoifletWavelet(18)), Coiflet24(new CoifletWavelet(24)), Coiflet30(new CoifletWavelet(30)),
		Daubechies4(new DaubechiesWavelet(4)), Daubechies6(new DaubechiesWavelet(6)), Daubechies8(new DaubechiesWavelet(8)), Daubechies10(new DaubechiesWavelet(10)), Daubechies12(new DaubechiesWavelet(12)), Daubechies14(new DaubechiesWavelet(14)), Daubechies16(new DaubechiesWavelet(16)), Daubechies18(new DaubechiesWavelet(18)), Daubechies20(new DaubechiesWavelet(20)),
		Symlet8(new SymletWavelet(8)), Symlet10(new SymletWavelet(10)), Symlet12(new SymletWavelet(12)), Symlet14(new SymletWavelet(14)), Symlet16(new SymletWavelet(16)), Symlet18(new SymletWavelet(18)), Symlet20(new SymletWavelet(20)),
		BestLocalized14(new BestLocalizedWavelet(14)), BestLocalized18(new BestLocalizedWavelet(18)), BestLocalized20(new BestLocalizedWavelet(20));

		private final Wavelet wavelet;

		Mode(Wavelet wavelet) {
			this.wavelet = wavelet;
		}
	}

	private final Mode mode;

	public Denoise(Mode mode) {
		this.mode = mode;
	}

	@Override
	public double[] calculate(double[] values) {
		double[] result = values.clone();
		WaveletShrinkage.denoise(result, mode.wavelet);
		return result;
	}

}
