package io.intino.sumus.chronos;

import io.intino.sumus.chronos.itl.ItlReader;
import io.intino.sumus.chronos.timelines.TimelineReader;
import io.intino.sumus.chronos.timelines.TimelineWriter;
import io.intino.sumus.chronos.timelines.writers.FileTimelineWriter;

import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;

import static java.nio.file.StandardOpenOption.READ;
import static java.util.stream.Collectors.toList;

public class Timelines {

	public static TimelineStore append(String sensor, File file, Instant instant, Period period, MeasurementsVector measurements) throws IOException {
		try(TimelineWriter writer = new FileTimelineWriter(sensor, file, true)) {
			writer.sensorModel(measurements.sensorModel());
			writer.timeModel(instant, period);
			writer.set(measurements.toArray());
		}
		return TimelineStore.of(file);
	}

	public static Timeline readItl(File file) throws IOException {
		return ItlReader.read(file);
	}

	public static Timeline readItl(List<String> lines) {
		return ItlReader.read(lines);
	}

	public static Timeline readItl(String[] lines) {
		return ItlReader.read(Arrays.stream(lines).collect(toList()));
	}

	public static Timeline read(File file) throws IOException {
		return read(FileChannel.open(file.toPath(), READ));
	}

	public static Timeline read(ReadableByteChannel channel) {
		try(TimelineReader reader = new TimelineReader(channel)) {
			TimelineImpl.Builder builder = new TimelineImpl.Builder((int) reader.header().recordCount());
			while(reader.hasNext()) {
				TimelineStore.Block block = reader.next();
				if(block.mark() != TimelineStore.Data.MARK) continue;
				builder.set(reader.sensorModel(), (TimelineStore.Data) block);
			}
			return builder.build();
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}
}
