package io.intino.sumus.chronos;

import java.time.Instant;
import java.util.Objects;

import static io.intino.sumus.chronos.State.Off;
import static io.intino.sumus.chronos.State.On;

public class Shot {
	public final String signal;
	public final Instant ts;
	public final State state;

	public Shot(Instant ts, State state, String signal) {
		this.ts = ts;
		this.state = state;
		this.signal = signal;
	}

	public static Shot on(long seconds, String signal) {
		return on(Instant.ofEpochSecond(seconds), signal);
	}

	public static Shot off(long seconds, String signal) {
		return off(Instant.ofEpochSecond(seconds), signal);
	}

	public static Shot on(Instant instant, String signal) {
		return new Shot(instant, On, signal);
	}

	public static Shot off(Instant instant, String signal) {
		return new Shot(instant, Off, signal);
	}

	@Override
	public String toString() {
		return String.join(" ", ts.toString(), signal, state.name());
	}

	@Override
	public boolean equals(Object o) {
		if (o == null || getClass() != o.getClass()) return false;
		return this == o || equals((Shot) o);
	}

	private boolean equals(Shot shot) {
		return Objects.equals(signal, shot.signal) && Objects.equals(ts, shot.ts) && state == shot.state;
	}

	@Override
	public int hashCode() {
		return Objects.hash(signal, ts, state);
	}
}
