package io.intino.sumus.chronos;

import java.util.Arrays;

public class MeasurementBuffer {

	public static final int INITIAL_CAPACITY = 16;

	private final Magnitude magnitude;
	private double[] measurements;
	private int size;

	public MeasurementBuffer(Magnitude magnitude) {
		this(magnitude, INITIAL_CAPACITY);
	}

	public MeasurementBuffer(Magnitude magnitude, int initialCapacity) {
		this.magnitude = magnitude;
		this.measurements = new double[initialCapacity];
	}

	public Magnitude magnitude() {
		return magnitude;
	}

	public MeasurementBuffer add(double measurement) {
		if(size >= measurements.length) resize();
		measurements[size++] = measurement;
		return this;
	}

	public double reduce() {
		return reduce(magnitude.operator());
	}

	public double reduce(Magnitude.Model.Operator operator) {
		return operator.reduce(measurements);
	}

	public double[] toArray() {
		return measurements;
	}

	private void resize() {
		measurements = Arrays.copyOf(measurements, measurements.length * 2);
	}
}
