package io.intino.sumus.chronos;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

import static java.lang.Integer.parseInt;
import static java.util.stream.Collectors.toSet;

public class Group {
	public final String name;
	public final Set<String> signals;

	public Group(String name) {
		this(name, new HashSet<>());
	}

	public Group(String name, Set<String> signals) {
		this.name = name;
		this.signals = signals;
	}

	public boolean contains(String signal) {
		return signals.contains(signal);
	}

	public void put(String signal) {
		signals.add(signal);
	}

	public void remove(String signal) {
		signals.remove(signal);
	}

	public Set<String> signalsThatAreNotIn(String[] signals) {
		Set<String> result = new HashSet<>(this.signals);
		result.removeAll(Set.of(signals));
		return result;
	}

	@Override
	public boolean equals(Object o) {
		return o != null && getClass() == o.getClass() && (this == o || equals((Group) o));
	}

	private boolean equals(Group group) {
		return Objects.equals(name, group.name) && Objects.equals(signals, group.signals);
	}

	@Override
	public int hashCode() {
		return Objects.hash(name, signals);
	}

	@Override
	public String toString() {
		return name + "-" + signals.size();
	}
}
