/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos;

import io.intino.sumus.chronos.Period;
import io.intino.sumus.chronos.Reel;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.HashSet;
import java.util.Set;

public class ReelFile {
    private final File file;
    private final Header header;

    private ReelFile(File file) throws IOException {
        this.file = file;
        this.header = new Header();
    }

    public static ReelFile create(File file) throws IOException {
        return new ReelFile(file);
    }

    public static ReelFile open(File file) throws IOException {
        return new ReelFile(file);
    }

    public ReelFile append(Reel.Shot ... shots) throws IOException {
        boolean dirty = false;
        for (Reel.Shot shot : shots) {
            if (this.stateOf(shot.signal()) == shot.state()) continue;
            Files.write(this.file.toPath(), this.serialize(shot), StandardOpenOption.APPEND);
            this.updateHeaderWith(shot);
            dirty = true;
        }
        if (dirty) {
            this.header.write();
        }
        return this;
    }

    public Reel.State stateOf(String signal) {
        return this.header.get(signal.hashCode());
    }

    private void updateHeaderWith(Reel.Shot shot) {
        if (shot.state() == Reel.State.On) {
            this.header.put(shot.signal());
        } else {
            this.header.remove(shot.signal());
        }
    }

    private byte[] serialize(Reel.Shot shot) {
        return String.format("%d\t%s\t%d\n", shot.ts().getEpochSecond(), shot.signal(), shot.state() == Reel.State.On ? 1 : 0).getBytes();
    }

    public Processor reel(Instant from, Instant to) {
        return new Processor(from, to);
    }

    public class Processor {
        private final Instant from;
        private final Instant to;

        public Processor(Instant from, Instant to) {
            this.from = from;
            this.to = to;
        }

        public Reel by(Period period) {
            Reel.Builder builder = new Reel.Builder(this.from, this.to).by(period);
            try (BufferedReader reader = new BufferedReader(new FileReader(ReelFile.this.file));){
                reader.skip(2048L);
                reader.lines().map(this::parse).forEach(builder::add);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return builder.close();
        }

        private Reel.Shot parse(String line) {
            return this.parse(line.split("\t"));
        }

        private Reel.Shot parse(final String[] split) {
            return new Reel.Shot(){

                @Override
                public Instant ts() {
                    return Instant.ofEpochSecond(Long.parseLong(split[0]));
                }

                @Override
                public String signal() {
                    return split[1];
                }

                @Override
                public Reel.State state() {
                    return Reel.State.of(split[2]);
                }
            };
        }
    }

    private class Header {
        private static final int SIZE = 2048;
        private final Set<Integer> hashes;

        public Header() throws IOException {
            this.hashes = ReelFile.this.file.exists() ? this.read() : this.create();
        }

        private Set<Integer> read() {
            HashSet<Integer> set = new HashSet<Integer>();
            try (DataInputStream is = new DataInputStream(new FileInputStream(ReelFile.this.file));){
                int max = 512;
                while (set.size() < 512) {
                    int hash = is.readInt();
                    if (hash == 0) {
                        break;
                    }
                    set.add(hash);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return set;
        }

        private Set<Integer> create() throws IOException {
            try (RandomAccessFile raf = new RandomAccessFile(ReelFile.this.file, "rw");){
                raf.write(new byte[2048]);
            }
            return new HashSet<Integer>();
        }

        public void write() throws IOException {
            try (RandomAccessFile raf = new RandomAccessFile(ReelFile.this.file, "rw");){
                raf.seek(0L);
                for (int hash : this.hashes) {
                    raf.writeInt(hash);
                }
                raf.write(0);
            }
        }

        public Reel.State get(String id) {
            return this.get(id.hashCode());
        }

        public Reel.State get(int hash) {
            return Reel.State.of(this.hashes.contains(hash));
        }

        public void put(String id) {
            this.put(id.hashCode());
        }

        public void put(int hash) {
            if (this.hashes.contains(hash)) {
                return;
            }
            this.hashes.add(hash);
        }

        public void remove(String id) {
            this.remove(id.hashCode());
        }

        public void remove(int hash) {
            if (!this.hashes.contains(hash)) {
                return;
            }
            this.hashes.remove(hash);
        }
    }
}

