/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos;

import io.intino.sumus.chronos.Format;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;

public class Magnitude
implements CharSequence {
    public final String label;
    public final Model model;

    public Magnitude(String definition) {
        this(definition.split(":"));
    }

    public Magnitude(String[] definition) {
        this(definition[0], Model.of(definition));
    }

    public Magnitude(String label, Model model) {
        this.label = label;
        this.model = model;
    }

    public Magnitude dimension(int index) {
        String[] split = this.label.split("\\|");
        String label = index >= 0 && index < split.length ? split[index] : "Total";
        return new Magnitude(label, this.model);
    }

    public Magnitude level(int index) {
        if (this.label.contains("|")) {
            return this;
        }
        int position = this.find(index);
        return position > 0 ? new Magnitude(this.label.substring(0, position), this.model) : this;
    }

    private int find(int index) {
        int position = 0;
        while (index > 0 && position >= 0) {
            position = this.label.indexOf(46, position + 1);
            --index;
        }
        return position;
    }

    @Override
    public int length() {
        return this.label.length();
    }

    @Override
    public char charAt(int index) {
        return this.label.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.label.subSequence(start, end);
    }

    public double reduce(double[] values) {
        return this.model.operator.reduce(values);
    }

    public double reduce(DoubleStream values) {
        return this.model.operator.reduce(values);
    }

    public int hashCode() {
        return this.label.hashCode();
    }

    public boolean equals(Object o) {
        return o != null && this.getClass() == o.getClass() && this.equals((Magnitude)o);
    }

    private boolean equals(Magnitude magnitude) {
        return this == magnitude || Objects.equals(this.label, magnitude.label);
    }

    @Override
    public String toString() {
        String model = this.model.toString();
        return model.isEmpty() ? this.label : this.label + ":" + model;
    }

    public static double[] NaN(int size) {
        double[] values = new double[size];
        Arrays.fill(values, Double.NaN);
        return values;
    }

    public double min() {
        return this.model.min;
    }

    public double max() {
        return this.model.max;
    }

    public String unit() {
        return this.model.unit;
    }

    public String symbol() {
        return this.model.symbol;
    }

    public Model.Operator operator() {
        return this.model.operator;
    }

    public Model.DistributionModel distributionModel() {
        return this.model.distributionModel;
    }

    public Model.DistributionTail distributionTail() {
        return this.model.distributionTail;
    }

    public String format(double value) {
        return this.model.format(value);
    }

    public static class Model {
        public static Model Default = new Model(Map.of());
        private final Map<String, String> attributes;
        public final double max;
        public final double min;
        public final String unit;
        public final String symbol;
        public final DistributionModel distributionModel;
        public final DistributionTail distributionTail;
        public final Format format;
        public final Operator operator;

        public static Model of(String definition) {
            return Model.of(definition.split(":"));
        }

        public static Model of(String[] attributes) {
            HashMap<String, String> result = new HashMap<String, String>();
            for (String attribute : attributes) {
                if (attribute.indexOf(61) < 0) continue;
                String[] data = attribute.split("=");
                result.put(data[0], data.length > 1 ? data[1] : "");
            }
            return new Model(result);
        }

        public Model(Map<String, String> attributes) {
            this.attributes = attributes;
            this.max = this.getDouble("max");
            this.min = this.getDouble("min");
            this.unit = attributes.getOrDefault("unit", "");
            this.symbol = attributes.getOrDefault("symbol", "");
            this.operator = Operator.of(attributes.getOrDefault("operator", "sum"));
            this.distributionModel = DistributionModel.of(attributes.get("distribution"));
            this.distributionTail = DistributionTail.of(attributes.get("tail"));
            this.format = Format.of(attributes.get("format"));
        }

        private double getDouble(String attribute) {
            return this.attributes.containsKey(attribute) ? Double.parseDouble(this.attributes.get(attribute)) : Double.NaN;
        }

        public Set<String> attributes() {
            return this.attributes.keySet();
        }

        public String attribute(String name) {
            return this.attributes.getOrDefault(name, "");
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this == o || Objects.equals(this.attributes, ((Model)o).attributes);
        }

        public int hashCode() {
            return Objects.hash(this.attributes);
        }

        public String toString() {
            return this.attributes().stream().sorted().map(this::toString).collect(Collectors.joining(":"));
        }

        private String toString(String attribute) {
            return attribute + "=" + this.attribute(attribute);
        }

        public Model max(int value) {
            return this.updateWith(Map.of("max", String.valueOf(value)));
        }

        public Model min(int value) {
            return this.updateWith(Map.of("min", String.valueOf(value)));
        }

        public Model unit(String value) {
            return this.updateWith(Map.of("unit", value));
        }

        public Model symbol(String value) {
            return this.updateWith(Map.of("symbol", value));
        }

        public Model operator(String value) {
            return this.updateWith(Map.of("operator", value));
        }

        public Model distribution(String value) {
            return this.updateWith(Map.of("distribution", value));
        }

        public Model updateWith(String definition) {
            return Model.of(definition.split(":"));
        }

        public Model updateWith(Map<String, String> data) {
            HashMap<String, String> attributes = new HashMap<String, String>(this.attributes);
            attributes.putAll(data);
            return new Model(attributes);
        }

        public String format(double value) {
            return this.format.format(value);
        }

        public static enum DistributionTail {
            Down,
            Up,
            Both;


            public static DistributionTail of(String value) {
                if (value != null) {
                    switch (value.toUpperCase()) {
                        case "DOWN": {
                            return Down;
                        }
                        case "UP": {
                            return Up;
                        }
                    }
                }
                return Both;
            }
        }

        public static enum DistributionModel {
            Normal,
            Poisson,
            Unknown;


            public static DistributionModel of(String value) {
                if (value != null) {
                    switch (value.toUpperCase()) {
                        case "POISSON": {
                            return Poisson;
                        }
                        case "UNKNOWN": {
                            return Unknown;
                        }
                    }
                }
                return Normal;
            }
        }

        public static enum Operator {
            Sum(Operator::sum),
            Average(Operator::average),
            MostFrequent(Operator::mostFrequent),
            Count(Operator::count),
            Max(Operator::max),
            Min(Operator::min),
            First(Operator::first),
            Last(Operator::last);

            private final Function<DoubleStream, Double> function;

            private Operator(Function<DoubleStream, Double> function) {
                this.function = function;
            }

            public static Operator of(String type) {
                switch (type.toLowerCase()) {
                    case "avg": 
                    case "average": {
                        return Average;
                    }
                    case "mostfrequent": {
                        return MostFrequent;
                    }
                    case "first": {
                        return First;
                    }
                    case "last": {
                        return Last;
                    }
                    case "max": {
                        return Max;
                    }
                    case "min": {
                        return Min;
                    }
                    case "count": {
                        return Count;
                    }
                }
                return Sum;
            }

            public double reduce(double[] values) {
                return this.function.apply(DoubleStream.of(values));
            }

            public double reduce(DoubleStream values) {
                return this.function.apply(values);
            }

            public static double count(DoubleStream stream) {
                return stream.count();
            }

            public static double sum(DoubleStream stream) {
                int[] count = new int[]{0};
                double sum = stream.peek(d -> {
                    count[0] = count[0] + 1;
                }).sum();
                return count[0] > 0 ? sum : Double.NaN;
            }

            public static double average(DoubleStream stream) {
                return stream.average().orElse(Double.NaN);
            }

            private static Double max(DoubleStream stream) {
                return stream.average().stream().max().orElse(Double.NaN);
            }

            private static Double min(DoubleStream stream) {
                return stream.average().stream().min().orElse(Double.NaN);
            }

            private static Double mostFrequent(DoubleStream stream) {
                return stream.boxed().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse(Double.NaN);
            }

            private static Double first(DoubleStream stream) {
                return stream.average().stream().findFirst().orElse(Double.NaN);
            }

            private static Double last(DoubleStream stream) {
                return stream.average().stream().reduce((double first, double second) -> second).orElse(Double.NaN);
            }

            public String toString() {
                return this.name();
            }
        }
    }
}

