/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.time.models.descriptive.sequence;

import io.intino.sumus.time.models.descriptive.sequence.Sequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public class NGram {
    private final Sequence sequence;
    private final int size;
    private final Map<Tuple, Integer> count;

    public static NGram of(Sequence sequence, int size) {
        return new NGram(sequence, size);
    }

    public NGram(Sequence sequence, int size) {
        this.sequence = sequence;
        this.size = size;
        this.count = new HashMap<Tuple, Integer>();
        this.add(sequence);
    }

    public double probabilityOf(String ... tokens) {
        return this.probabilityOf(this.valuesOf(tokens));
    }

    private int[] valuesOf(String[] tokens) {
        return Arrays.stream(tokens).mapToInt(this.sequence::indexOf).toArray();
    }

    private double probabilityOf(int[] tokens) {
        double probability = 1.0;
        for (int i = tokens.length; i >= this.size; --i) {
            probability *= this.probabilityOf(new Tuple(this.reverse(tokens, i - 1, this.size)));
        }
        return probability;
    }

    private int[] reverse(int[] tokens, int from, int size) {
        int[] data = new int[size];
        int i = 0;
        int j = from;
        while (i < size) {
            data[i] = j >= 0 ? tokens[j] : -1;
            ++i;
            --j;
        }
        return data;
    }

    private double probabilityOf(Tuple tuple) {
        return (double)this.count(tuple) / (double)this.count(tuple.tail());
    }

    private int count(Tuple tuple) {
        return this.count.getOrDefault(tuple, 0);
    }

    private void add(Sequence sequence) {
        sequence.forEach(this::add);
    }

    private void add(Sequence.Point point) {
        for (int i = this.size - 1; i <= this.size; ++i) {
            this.add(Tuple.of(point, i));
        }
    }

    private void add(Tuple tuple) {
        this.count.put(tuple, this.count(tuple) + 1);
    }

    public List<Suggestion> suggestionsFor(String ... tokens) {
        return this.suggestionsFor(this.valuesOf(tokens));
    }

    private List<Suggestion> suggestionsFor(int[] tokens) {
        ArrayList<Suggestion> result = new ArrayList<Suggestion>();
        for (Tuple tuple : this.count.keySet()) {
            if (!tuple.contains(tokens)) continue;
            result.add(new Suggestion(tuple));
        }
        return result;
    }

    public static class Tuple {
        final int[] tokens;

        public Tuple(int[] tokens) {
            this.tokens = tokens;
        }

        public Tuple tail() {
            return new Tuple(Arrays.copyOfRange(this.tokens, 1, this.length()));
        }

        public int head() {
            return this.tokens[0];
        }

        private int length() {
            return this.tokens.length;
        }

        public boolean contains(int[] tokens) {
            if (tokens.length >= this.tokens.length) {
                return false;
            }
            return IntStream.range(0, tokens.length).allMatch(i -> tokens[i] == this.tokens[i]);
        }

        static Tuple of(Sequence.Point point, int size) {
            int[] data = new int[size];
            for (int i = 0; i < size; ++i) {
                if (point == null) continue;
                data[i] = point.token();
                point = point.prev();
            }
            return new Tuple(data);
        }

        public boolean equals(Object o) {
            return o instanceof Tuple && Arrays.equals(this.tokens, ((Tuple)o).tokens);
        }

        public int hashCode() {
            return Arrays.hashCode(this.tokens);
        }

        public String toString() {
            return Arrays.toString(this.tokens);
        }
    }

    public class Suggestion {
        public final String symbol;
        public final double probability;

        public Suggestion(Tuple tuple) {
            this.symbol = NGram.this.sequence.symbol(tuple.head());
            this.probability = NGram.this.probabilityOf(tuple);
        }

        public String toString() {
            return "Suggestion{symbol='" + this.symbol + "', probability=" + this.probability + "}";
        }
    }
}

