/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.time;

import io.intino.sumus.time.Magnitude;
import io.intino.sumus.time.Period;
import io.intino.sumus.time.Program;
import io.intino.sumus.time.TimeSeries;
import io.intino.sumus.time.itl.ItlReader;
import io.intino.sumus.time.processors.Interpolator;
import io.intino.sumus.time.processors.Resampler;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class Timeline
implements Iterable<Point> {
    public static final Timeline Null = new Timeline(new Instant[0], new HashMap<Magnitude, double[]>());
    public final Instant[] instants;
    private final Map<Magnitude, double[]> magnitudes;

    private Timeline(Instant[] instants, Map<Magnitude, double[]> magnitudes) {
        this.instants = instants;
        this.magnitudes = magnitudes;
    }

    public int size() {
        return this.magnitudes.size();
    }

    public Set<Magnitude> magnitudes() {
        return this.magnitudes.keySet();
    }

    public boolean has(String magnitude) {
        return this.has(new Magnitude(magnitude));
    }

    public boolean has(Magnitude magnitude) {
        return this.magnitudes.containsKey(magnitude);
    }

    public TimeSeries get(String magnitude) {
        return this.has(magnitude) ? this.get(this.find(magnitude)) : this.emptyTimeSeries();
    }

    public TimeSeries get(Magnitude magnitude) {
        return new TimeSeries(magnitude.model, this.instants, this.magnitudes.getOrDefault(magnitude, Magnitude.NaN(this.instants.length)));
    }

    private TimeSeries emptyTimeSeries() {
        return new TimeSeries(Magnitude.Model.Default, this.instants, Magnitude.NaN(this.instants.length));
    }

    public static Timeline empty() {
        return new Timeline(new Instant[0], new HashMap<Magnitude, double[]>());
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public int length() {
        return this.instants.length;
    }

    public boolean isBefore(Timeline timeline) {
        if (timeline.length() == 0) {
            return false;
        }
        return this.isEndOfTimes(timeline.firstInstant());
    }

    public boolean isAfter(Timeline timeline) {
        if (timeline.length() == 0) {
            return false;
        }
        return this.isBeginningOfTimes(timeline.lastInstant());
    }

    public Point first() {
        return this.point(0);
    }

    public Point last() {
        return this.point(this.lastIndex());
    }

    public Point at(Instant instant) {
        return this.point(this.indexOf(instant));
    }

    public Timeline head(int length) {
        return this.sub(0, this.limitHigh(length));
    }

    public Timeline tail(int length) {
        return this.sub(this.limitLow(this.length() - length), this.length());
    }

    public Timeline from(Instant instant) {
        if (this.isEndOfTimes(instant)) {
            return Timeline.empty();
        }
        return this.sub(this.indexOf(instant), this.length());
    }

    public Timeline from(Instant instant, int length) {
        if (this.isEndOfTimes(instant)) {
            return Timeline.empty();
        }
        int from = this.indexOf(instant);
        return length > 0 ? this.sub(from, this.limitHigh(from + length)) : this.sub(this.limitLow(from + 1 + length), this.limitHigh(from + 1));
    }

    public Timeline from(Instant instant, Instant to) {
        if (this.isEndOfTimes(instant)) {
            return Timeline.empty();
        }
        if (this.isEndOfTimes(to)) {
            return this.from(instant);
        }
        return this.sub(this.indexOf(instant), this.indexOf(to));
    }

    public Timeline to(Instant instant) {
        if (this.isEndOfTimes(instant)) {
            return this;
        }
        return this.sub(0, this.indexOf(instant));
    }

    private Point point(int index) {
        return this.isInRange(index) ? new Point(index) : null;
    }

    private boolean isBeginningOfTimes(Instant instant) {
        return this.firstInstant().isAfter(instant);
    }

    private boolean isEndOfTimes(Instant instant) {
        return this.lastInstant().isBefore(instant);
    }

    private int limitLow(int offset) {
        return Math.max(0, offset);
    }

    private int limitHigh(int offset) {
        return Math.min(offset, this.length());
    }

    private Instant firstInstant() {
        return this.instants[0];
    }

    private Instant lastInstant() {
        return this.instants[this.lastIndex()];
    }

    private Timeline sub(int from, int to) {
        return new Timeline(this.instants(from, to), this.values(from, to));
    }

    private Magnitude find(String label) {
        return this.magnitudes.keySet().stream().filter(m -> m.label.equalsIgnoreCase(label)).findFirst().orElse(null);
    }

    public Stream<Point> stream() {
        return IntStream.iterate(0, i -> i < this.length(), i -> i + 1).mapToObj(this::point);
    }

    @Override
    public Iterator<Point> iterator() {
        return new Iterator<Point>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Timeline.this.length();
            }

            @Override
            public Point next() {
                return new Point(this.i++);
            }
        };
    }

    public Timeline add(Timeline timeline) {
        assert (Arrays.equals(timeline.instants, this.instants));
        Timeline result = new Timeline(this.instants, new HashMap<Magnitude, double[]>(this.magnitudes));
        for (Magnitude magnitude : timeline.magnitudes()) {
            TimeSeries series = result.has(magnitude) ? timeline.get(magnitude).plus(this.get(magnitude)) : timeline.get(magnitude);
            result.put(magnitude, series);
        }
        return result;
    }

    public Timeline add(String magnitude, TimeSeries timeSeries) {
        return this.add(new Magnitude(magnitude), timeSeries);
    }

    public Timeline add(Magnitude magnitude, TimeSeries timeSeries) {
        assert (Arrays.equals(timeSeries.instants, this.instants));
        Timeline result = new Timeline(this.instants, new HashMap<Magnitude, double[]>(this.magnitudes));
        result.put(magnitude, timeSeries);
        return result;
    }

    public Timeline add(String magnitude, Function<Timeline, TimeSeries> function) {
        return this.add(new Magnitude(magnitude), function);
    }

    public Timeline add(Magnitude magnitude, Function<Timeline, TimeSeries> function) {
        Timeline result = new Timeline(this.instants, new HashMap<Magnitude, double[]>(this.magnitudes));
        result.put(magnitude, function.apply(this));
        return result;
    }

    public Timeline concat(Timeline timeline) {
        assert (this.isBefore(timeline));
        Timeline result = new Timeline(TimeSeries.concat(this.instants, timeline.instants), new HashMap<Magnitude, double[]>());
        Set<Magnitude> magnitudes = Timeline.concat(this.magnitudes(), timeline.magnitudes());
        for (Magnitude magnitude : magnitudes) {
            result.put(magnitude, TimeSeries.concat(this.get((Magnitude)magnitude).values, timeline.get((Magnitude)magnitude).values));
        }
        return result;
    }

    public Timeline compose(Function<Magnitude, Magnitude> function) {
        Timeline result = new Timeline(this.instants, new HashMap<Magnitude, double[]>());
        for (Magnitude magnitude : this.magnitudes()) {
            Magnitude m = function.apply(magnitude);
            TimeSeries series = result.has(m) ? result.get(m).plus(this.get(magnitude)) : this.get(magnitude);
            result.put(m, series);
        }
        return result;
    }

    private void put(Magnitude magnitude, TimeSeries series) {
        this.magnitudes.put(magnitude, series.values);
    }

    private void put(Magnitude magnitude, double[] values) {
        this.put(magnitude, new TimeSeries(Magnitude.Model.Default, this.instants, values));
    }

    public Timeline resampleBy(Period period) {
        return this.length() > 0 ? this.resampleBy(period, this.sizeWith(period)) : this;
    }

    public Timeline resampleBy(Period period, int size) {
        return new Resampler(this).execute(period, size);
    }

    public Timeline execute(Program program) {
        return program.run(this);
    }

    public Timeline interpolate() {
        return new Interpolator(this).execute();
    }

    private static Set<Magnitude> concat(Set<Magnitude> a, Set<Magnitude> b) {
        HashSet<Magnitude> magnitudes = new HashSet<Magnitude>();
        magnitudes.addAll(a);
        magnitudes.addAll(b);
        return magnitudes;
    }

    private int sizeWith(Period period) {
        return period.length(this.first().instant(), this.last().instant().plusSeconds(1L));
    }

    private Timeline standardize(Timeline timeline) {
        Timeline result = new Timeline(timeline.instants, new HashMap<Magnitude, double[]>());
        for (Magnitude magnitude : this.magnitudes()) {
            result.put(magnitude, this.get(magnitude).standardize());
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this == o || this.equals((Timeline)o);
    }

    private boolean equals(Timeline timeline) {
        return Arrays.equals(this.instants, timeline.instants) && this.magnitudes.size() == timeline.size() && this.magnitudes.keySet().stream().map(m -> Arrays.equals(this.magnitudes.get(m), timeline.magnitudes.get(m))).reduce(true, (a, b) -> a != false && b != false) != false;
    }

    public int hashCode() {
        int result = Objects.hash(this.magnitudes);
        result = 31 * result + Arrays.hashCode(this.instants);
        return result;
    }

    private int indexOf(Instant instant) {
        int index = Arrays.binarySearch(this.instants, instant);
        return index >= 0 ? index : Math.min(Math.abs(-index - 1), this.lastIndex());
    }

    private int lastIndex() {
        return this.length() - 1;
    }

    private boolean isInRange(int index) {
        return index >= 0 && index < this.length();
    }

    private Instant[] instants(int from, int to) {
        return Arrays.copyOfRange(this.instants, from, to);
    }

    private Map<Magnitude, double[]> values(int from, int to) {
        return this.magnitudes().stream().collect(Collectors.toMap(m -> m, m -> Arrays.copyOfRange(this.valuesOf((Magnitude)m), from, to)));
    }

    private double[] valuesOf(Magnitude magnitude) {
        return this.magnitudes.get(magnitude);
    }

    public Map<String, double[]> collect(String ... magnitudes) {
        return Arrays.stream(magnitudes).collect(Collectors.toMap(m -> m, m -> this.get((String)m).values, (a, b) -> b));
    }

    public static Timeline read(File file) throws IOException {
        return ItlReader.read(file);
    }

    public static Timeline read(List<String> lines) {
        return ItlReader.read(lines);
    }

    public static Timeline read(String[] lines) {
        return ItlReader.read(Arrays.stream(lines).collect(Collectors.toList()));
    }

    public static class Builder {
        public final Instant[] instants;
        public final Map<Magnitude, double[]> magnitudes;
        protected int position;

        public Builder(int size) {
            this(new Instant[size]);
        }

        public Builder(Instant[] instants) {
            this.instants = instants;
            this.magnitudes = new HashMap<Magnitude, double[]>();
            this.position = -1;
        }

        public Magnitude get(String magnitude) {
            return this.magnitudes().stream().filter(m -> m.label.equals(magnitude)).findFirst().orElse(null);
        }

        private Set<Magnitude> magnitudes() {
            return this.magnitudes.keySet();
        }

        public Builder put(Timeline timeline) {
            this.magnitudes.putAll(timeline.magnitudes);
            return this;
        }

        public Builder put(Magnitude magnitude, TimeSeries series) {
            assert (this.instants.length == series.length());
            this.magnitudes.put(magnitude, series.values);
            return this;
        }

        public Builder put(Magnitude magnitude, double[] values) {
            assert (this.instants.length == values.length);
            this.magnitudes.put(magnitude, values);
            return this;
        }

        public Builder put(Map<Magnitude, double[]> values) {
            values.keySet().forEach(m -> this.put((Magnitude)m, new TimeSeries(Magnitude.Model.Default, this.instants, (double[])values.get(m))));
            return this;
        }

        public Builder set(Instant instant) {
            this.instants[++this.position] = instant;
            return this;
        }

        public boolean isComplete() {
            return this.position + 1 >= this.instants.length;
        }

        public Builder set(String magnitude, double value) {
            return this.set(new Magnitude(magnitude), value);
        }

        public Builder set(Magnitude magnitude, double value) {
            if (magnitude == null || Double.isNaN(value)) {
                return this;
            }
            this.putIfNotExists(magnitude);
            this.magnitudes.get((Object)magnitude)[this.position] = value;
            return this;
        }

        private void putIfNotExists(Magnitude magnitude) {
            if (this.magnitudes.containsKey(magnitude)) {
                return;
            }
            this.magnitudes.put(magnitude, Magnitude.NaN(this.instants.length));
        }

        public Timeline close() {
            return new Timeline(this.instants, this.magnitudes);
        }

        public TimeSeries series(Magnitude magnitude) {
            return new TimeSeries(Magnitude.Model.Default, this.instants, this.magnitudes.get(magnitude));
        }
    }

    public class Point {
        final int index;

        public Point(int index) {
            this.index = index;
        }

        public Instant instant() {
            return Timeline.this.instants[this.index];
        }

        public Set<Magnitude> magnitudes() {
            return Timeline.this.magnitudes();
        }

        public boolean has(String magnitude) {
            return this.has(new Magnitude(magnitude));
        }

        public boolean has(Magnitude magnitude) {
            return Timeline.this.has(magnitude);
        }

        public double value(String magnitude) {
            return this.value(new Magnitude(magnitude));
        }

        public double value(Magnitude magnitude) {
            return this.has(magnitude) ? Timeline.this.valuesOf(magnitude)[this.index] : Double.NaN;
        }

        public String toString() {
            return this.instant() + this.magnitudes().stream().map(m -> "\t" + this.format(this.value((Magnitude)m))).collect(Collectors.joining());
        }

        public Stream<Point> forward() {
            return IntStream.range(this.index, Timeline.this.length()).mapToObj(x$0 -> Timeline.this.point(x$0));
        }

        public Stream<Point> backward() {
            return IntStream.iterate(this.index, i -> i >= 0, i -> i - 1).mapToObj(x$0 -> Timeline.this.point(x$0));
        }

        private String format(double value) {
            long v = (long)value;
            return value == (double)v ? String.valueOf(v) : String.valueOf(value);
        }

        public Point next() {
            return this.step(1);
        }

        public Point prev() {
            return this.step(-1);
        }

        public Point step(int value) {
            return Timeline.this.point(this.index + value);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this == o || this.index == ((Point)o).index;
        }

        public int hashCode() {
            return Objects.hash(this.index);
        }
    }
}

