/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.time.models.descriptive.sequence;

import io.intino.sumus.time.Period;
import io.intino.sumus.time.Timeline;
import io.intino.sumus.time.models.descriptive.sequence.Histogram;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class Sequence
implements Iterable<Point> {
    private final String[] symbols;
    private final int[] tokens;
    private final Map<String, Integer> index;

    public static Builder of(Timeline timeline) {
        return new Builder(timeline);
    }

    public static Sequence of(String ... tokens) {
        return new Sequence(tokens);
    }

    private Sequence(String[] tokens) {
        this.symbols = (String[])Arrays.stream(tokens).distinct().toArray(String[]::new);
        this.index = Sequence.index(this.symbols);
        this.tokens = Arrays.stream(tokens).mapToInt(this::indexOf).toArray();
    }

    private static Map<String, Integer> index(String[] symbols) {
        HashMap<String, Integer> index = new HashMap<String, Integer>();
        for (String symbol : symbols) {
            index.put(symbol, index.size());
        }
        return index;
    }

    public Histogram histogram() {
        return Histogram.of(this);
    }

    public String[] symbols() {
        return this.symbols;
    }

    public int length() {
        return this.tokens.length;
    }

    public Point first() {
        return this.point(0);
    }

    public Point last() {
        return this.point(this.length() - 1);
    }

    public Point point(int index) {
        return index >= 0 && index < this.length() ? new Point(index) : null;
    }

    public Stream<Point> stream() {
        return IntStream.range(0, this.length()).mapToObj(this::point);
    }

    public String symbol(int index) {
        return this.symbols[this.tokens[index]];
    }

    public int indexOf(String symbol) {
        return this.index.getOrDefault(symbol, -1);
    }

    @Override
    public Iterator<Point> iterator() {
        return new Iterator<Point>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < Sequence.this.tokens.length;
            }

            @Override
            public Point next() {
                return Sequence.this.point(this.index++);
            }
        };
    }

    public String toString() {
        return Arrays.toString(this.tokens);
    }

    public static interface Quantization {
        public String get(Timeline.Point var1);

        public static Quantization of(Period period) {
            return point -> period.labelOf(point.instant());
        }
    }

    public static class Builder {
        private final Timeline timeline;

        public Builder(Timeline timeline) {
            this.timeline = timeline;
        }

        public Sequence by(Period period) {
            return this.by(Quantization.of(period));
        }

        public Sequence by(Quantization quantization) {
            return new Sequence(this.calculate(quantization));
        }

        private String[] calculate(Quantization quantization) {
            return (String[])this.timeline.stream().map(quantization::get).toArray(String[]::new);
        }
    }

    public class Point {
        private final int index;

        public Point(int index) {
            this.index = index;
        }

        public int token() {
            return Sequence.this.tokens[this.index];
        }

        public String symbol() {
            return Sequence.this.symbols[this.token()];
        }

        public Point next() {
            return Sequence.this.point(this.index + 1);
        }

        public Point prev() {
            return Sequence.this.point(this.index - 1);
        }

        public Point step(int offset) {
            return Sequence.this.point(this.index + offset);
        }

        public Stream<Point> forward() {
            return IntStream.range(this.index, Sequence.this.length()).mapToObj(Sequence.this::point);
        }

        public Stream<Point> backward() {
            return IntStream.iterate(this.index, i -> i >= 0, i -> i - 1).mapToObj(Sequence.this::point);
        }

        public String toString() {
            return this.symbol();
        }
    }
}

