/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.time.itl;

import io.intino.sumus.time.Timeline;
import io.intino.sumus.time.itl.ItlParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public class ItlReader {
    public static Timeline read(File file) throws IOException {
        return ItlReader.read(ItlReader.linesIn(file));
    }

    public static Timeline read(List<String> lines) {
        ItlParser parser = new ItlParser(ItlReader.numberOfMeasurementsIn(lines));
        lines.forEach(parser);
        return parser.timeline();
    }

    private static List<String> linesIn(File file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            List<String> list = reader.lines().filter(l -> !l.isEmpty()).collect(Collectors.toList());
            return list;
        }
    }

    private static int numberOfMeasurementsIn(List<String> lines) {
        return (int)lines.stream().filter(l -> l.charAt(0) != '@').count();
    }
}

