package io.intino.sumus.time.filters;


import io.intino.sumus.time.Filter;
import ro.hasna.ts.math.filter.ExponentialMovingAverageFilter;
import ro.hasna.ts.math.filter.MovingAverageFilter;

public class MovingAverage  {

	public static Filter of(int observations) {
		return new MovingAverageFilter(observations)::filter;
	}

	public static Filter of(double smoothingFactor) {
		return new ExponentialMovingAverageFilter(smoothingFactor)::filter;
	}


}
