/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.time.models.descriptive.timeseries;

import io.intino.sumus.time.Magnitude;
import io.intino.sumus.time.Period;
import io.intino.sumus.time.TimeSeries;
import io.intino.sumus.time.Timeline;
import io.intino.sumus.time.models.descriptive.sequence.Sequence;
import io.intino.sumus.time.models.descriptive.timeline.Summary;
import io.intino.sumus.time.models.descriptive.timeseries.Distribution;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;

public class Trend {
    public final Timeline timeline;
    public final int window;

    public static Builder of(TimeSeries timeSeries, int window) {
        return new Builder(timeSeries, window);
    }

    private Trend(Timeline timeline, int window) {
        this.timeline = timeline;
        this.window = window;
    }

    public TimeSeries direction() {
        return this.timeline.get("RSI");
    }

    public TimeSeries strength() {
        return this.timeline.get("ADX");
    }

    public TimeSeries volatility() {
        return this.timeline.get("ATR");
    }

    public State at(Instant instant) {
        return this.at(this.timeline.at(instant));
    }

    private State at(Timeline.Point point) {
        return new State(point, Direction.of(point.value("RSI")), Strength.of(point.value("ADX")), Volatility.of(point.value("ATR")));
    }

    public static enum Volatility {
        VeryLow,
        Low,
        Medium,
        High,
        VeryHigh;


        public static Volatility of(double atr) {
            if (atr < 0.5) {
                return VeryLow;
            }
            if (atr < 1.0) {
                return Low;
            }
            if (atr < 1.5) {
                return Medium;
            }
            if (atr < 2.0) {
                return High;
            }
            return VeryHigh;
        }

        public boolean isGreaterThan(Volatility volatility) {
            return this.ordinal() > volatility.ordinal();
        }
    }

    public static enum Strength {
        Weak,
        Medium,
        Strong,
        VeryStrong;


        public static Strength of(double adx) {
            if (adx < 25.0) {
                return Weak;
            }
            if (adx < 50.0) {
                return Medium;
            }
            if (adx < 75.0) {
                return Strong;
            }
            return VeryStrong;
        }

        public boolean isGreaterThan(Strength value) {
            return this.ordinal() > value.ordinal();
        }
    }

    public static enum Direction {
        Down,
        Neutral,
        Up;


        public static Direction of(double rsi) {
            return rsi > 70.0 ? Down : (rsi < 30.0 ? Up : Neutral);
        }
    }

    public static class Builder {
        private final TimeSeries timeSeries;
        private final double sd;
        private int window;

        private Builder(TimeSeries timeSeries, int window) {
            this.timeSeries = timeSeries;
            this.sd = new Distribution(timeSeries).sd();
            this.window = window;
        }

        public Trend by(Period period) {
            return new Trend(this.analyzeBy(period), this.window);
        }

        private Timeline analyzeBy(Period period) {
            return this.createTimelineFrom(this.summaryWith(period));
        }

        private Summary summaryWith(Period period) {
            return Summary.of(Builder.asTimeline(this.timeSeries)).by(Sequence.Quantization.of(period));
        }

        private static Timeline asTimeline(TimeSeries series) {
            return new Timeline.Builder(series.instants).put(new Magnitude("value", series.model), series).close();
        }

        private Timeline createTimelineFrom(Summary summary) {
            Timeline.Builder builder = new Timeline.Builder(summary.length());
            Distribution yesterday = summary.first().distribution("value");
            for (Summary.Point point : summary) {
                Distribution today = point.distribution("value");
                builder.set(this.parseInstant(point.label()));
                builder.set("open", today.open);
                builder.set("max", today.max);
                builder.set("min", today.min);
                builder.set("close", today.close);
                builder.set("sum", today.sum);
                builder.set("mean", today.mean());
                builder.set("TR", Builder.trueRange(today, yesterday));
                builder.set("DM+", Builder.dmMax(today, yesterday));
                builder.set("DM-", Builder.dmMin(today, yesterday));
                builder.set("RSI", this.relativeStrengthIndex(point));
                yesterday = today;
            }
            return this.terminate(builder.close());
        }

        private Instant parseInstant(String label) {
            int[] date = this.decomposeDate(label);
            return LocalDateTime.of(date[0], date[1], date[2], date[3], date[4], date[5]).toInstant(ZoneOffset.UTC);
        }

        private int[] decomposeDate(String label) {
            int[] date = new int[6];
            date[0] = Integer.parseInt(label.substring(0, 4));
            date[1] = 1;
            date[2] = 2;
            int i = 1;
            for (int pos = 4; i < 6 && pos < label.length(); ++i, pos += 2) {
                date[i] = Integer.parseInt(label.substring(pos, pos + 2));
            }
            return date;
        }

        private double relativeStrengthIndex(Summary.Point today) {
            double[] values = today.backward().limit(this.window + 1).mapToDouble(p -> p.distribution((String)"value").close).toArray();
            for (int i = values.length - 1; i >= 1; --i) {
                values[i] = values[i] - values[i - 1];
            }
            double averageGain = Arrays.stream(values).skip(1L).filter(v -> v > 0.0).average().orElse(0.0);
            double averageLoss = Arrays.stream(values).skip(1L).filter(v -> v < 0.0).average().orElse(0.0);
            return averageLoss != 0.0 ? 100.0 - 100.0 / (1.0 + averageGain / Math.abs(averageLoss)) : 100.0;
        }

        private Timeline terminate(Timeline timeline) {
            TimeSeries atr = timeline.get("TR").movingAverage(this.window);
            TimeSeries factor = atr.inverse().times(100.0);
            TimeSeries highDI = timeline.get("DM+").exponentialMovingAverage(this.window).times(factor);
            TimeSeries lowDI = timeline.get("DM-").exponentialMovingAverage(this.window).times(factor);
            TimeSeries directionalIndex = highDI.minus(lowDI).abs().dividedBy(highDI.plus(lowDI)).times(100.0);
            return timeline.add("ATR|tail=up", atr.times(1.0 / this.sd)).add("ADX", directionalIndex.exponentialMovingAverage(this.window));
        }

        private static double dmMax(Distribution today, Distribution yesterday) {
            double change = today.close - yesterday.close;
            double highChange = today.max - yesterday.max;
            return change > 0.0 && change > highChange ? change : 0.0;
        }

        private static double dmMin(Distribution today, Distribution yesterday) {
            double change = yesterday.close - today.close;
            double lowChange = today.min - yesterday.min;
            return change > 0.0 && change > lowChange ? change : 0.0;
        }

        private static double trueRange(Distribution today, Distribution yesterday) {
            return Math.max(today.max, yesterday.close) - Math.min(today.min, yesterday.close);
        }
    }

    public static class State {
        public final Timeline.Point point;
        public final Direction direction;
        public final Strength strength;
        public final Volatility volatility;

        public State(Timeline.Point point, Direction direction, Strength strength, Volatility volatility) {
            this.point = point;
            this.direction = direction;
            this.strength = strength;
            this.volatility = volatility;
        }

        public String toString() {
            return this.point + ": " + this.direction + "," + this.strength + "," + this.volatility;
        }
    }
}

