/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.chronos;

import io.intino.sumus.chronos.Period;
import io.intino.sumus.chronos.Reel;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ReelFile {
    private final File file;
    private final Header header;
    private final Instant from;

    private ReelFile(File file) throws IOException {
        this.file = file;
        this.header = new Header();
        this.from = this.readFirstInstantFrom(file);
    }

    public static ReelFile open(File file) throws IOException {
        return new ReelFile(file);
    }

    public ReelFile set(Instant instant, String ... signals) throws IOException {
        ArrayList<Reel.Shot> shots = new ArrayList<Reel.Shot>();
        shots.addAll(this.shotsToTurnOff(instant, this.signalsThatAreNotIn(signals)));
        shots.addAll(this.shotsToTurnOn(instant, signals));
        return this.append(shots);
    }

    private List<Reel.Shot> shotsToTurnOn(Instant now, String[] signals) {
        return Arrays.stream(signals).filter(s -> !this.header.contains((String)s)).map(s -> new Reel.Shot(now, Reel.State.On, (String)s)).collect(Collectors.toList());
    }

    private List<Reel.Shot> shotsToTurnOff(Instant now, Set<Integer> signals) {
        return signals.stream().map(s -> new Reel.Shot(now, Reel.State.Off, (int)s)).collect(Collectors.toList());
    }

    private Set<Integer> signalsThatAreNotIn(String[] signals) {
        HashSet<Integer> result = new HashSet<Integer>(this.header.signals);
        result.removeAll(this.hashesOf(signals));
        return result;
    }

    private Set<Integer> hashesOf(String[] signals) {
        return Stream.of(signals).map(String::hashCode).collect(Collectors.toSet());
    }

    public Instant start() {
        return this.from;
    }

    public ReelFile append(Reel.Shot ... shots) throws IOException {
        return this.append(List.of(shots));
    }

    public ReelFile append(List<Reel.Shot> shots) throws IOException {
        boolean dirty = false;
        for (Reel.Shot shot : shots) {
            if (this.stateOf(shot.signal) == shot.state) continue;
            Files.write(this.file.toPath(), this.serialize(shot), StandardOpenOption.APPEND);
            this.updateHeaderWith(shot);
            dirty = true;
        }
        if (dirty) {
            this.header.write();
        }
        return this;
    }

    public Reel.State stateOf(String signal) {
        return this.header.get(this.hashOf(signal));
    }

    private int hashOf(String signal) {
        return signal.startsWith("#") ? Integer.parseInt(signal.substring(1)) : signal.hashCode();
    }

    private void updateHeaderWith(Reel.Shot shot) {
        if (shot.state == Reel.State.On) {
            this.header.put(shot.signal);
        } else {
            this.header.remove(shot.signal);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private byte[] serialize(Reel.Shot shot) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dos = new DataOutputStream(bos);){
                dos.writeLong(shot.ts.getEpochSecond());
                dos.writeByte(shot.state == Reel.State.On ? 1 : 0);
                if (shot.state == Reel.State.On) {
                    dos.writeUTF(shot.signal);
                } else {
                    dos.writeInt(shot.hash);
                }
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Processor reel(Instant from, Instant to) {
        return new Processor(from, to);
    }

    public Processor reel(Instant to) {
        return new Processor(this.from, to);
    }

    public Processor reel() {
        return new Processor(this.from, Instant.now());
    }

    private Instant readFirstInstantFrom(File file) {
        Instant instant;
        DataInputStream is = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            is.skip(2048L);
            instant = Instant.ofEpochSecond(is.readLong());
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return Instant.now();
            }
        }
        is.close();
        return instant;
    }

    public class Processor {
        private final Instant from;
        private final Instant to;

        public Processor(Instant from, Instant to) {
            this.from = from;
            this.to = to;
        }

        public Reel by(Period period) {
            Reel.Builder builder = new Reel.Builder(this.from, this.to).by(period);
            try {
                DataInputStream is = new DataInputStream(new BufferedInputStream(new FileInputStream(ReelFile.this.file)));
                try {
                    is.skip(2048L);
                    while (true) {
                        long seconds = is.readLong();
                        byte state = is.readByte();
                        if (state == 1) {
                            builder.add(this.on(seconds, is.readUTF()));
                            continue;
                        }
                        builder.add(this.off(seconds, is.readInt()));
                    }
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                return builder.close();
            }
        }

        private Reel.Shot on(long seconds, String signal) {
            return new Reel.Shot(Instant.ofEpochSecond(seconds), Reel.State.On, signal);
        }

        private Reel.Shot off(long seconds, int signal) {
            return new Reel.Shot(Instant.ofEpochSecond(seconds), Reel.State.Off, signal);
        }
    }

    private class Header {
        private static final int SIZE = 2048;
        private final Set<Integer> signals;

        public Header() throws IOException {
            this.signals = ReelFile.this.file.exists() ? this.read() : this.create();
        }

        private Set<Integer> read() {
            HashSet<Integer> set = new HashSet<Integer>();
            try (DataInputStream is = new DataInputStream(new FileInputStream(ReelFile.this.file));){
                int max = 512;
                while (set.size() < 512) {
                    int signal = is.readInt();
                    if (signal == 0) {
                        break;
                    }
                    set.add(signal);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return set;
        }

        private Set<Integer> create() throws IOException {
            try (RandomAccessFile raf = new RandomAccessFile(ReelFile.this.file, "rw");){
                raf.write(new byte[2048]);
            }
            return new HashSet<Integer>();
        }

        public void write() throws IOException {
            try (RandomAccessFile raf = new RandomAccessFile(ReelFile.this.file, "rw");){
                raf.seek(0L);
                for (int signal : this.signals) {
                    raf.writeInt(signal);
                }
                raf.write(0);
            }
        }

        public Reel.State get(String signal) {
            return this.get(signal.hashCode());
        }

        public Reel.State get(int signal) {
            return Reel.State.of(this.contains(signal));
        }

        public void put(String signal) {
            this.put(signal.hashCode());
        }

        public void put(int signal) {
            if (this.contains(signal)) {
                return;
            }
            this.signals.add(signal);
        }

        public void remove(String signal) {
            this.remove(ReelFile.this.hashOf(signal));
        }

        public void remove(int signal) {
            if (!this.contains(signal)) {
                return;
            }
            this.signals.remove(signal);
        }

        public boolean contains(String signal) {
            return this.signals.contains(signal.hashCode());
        }

        public boolean contains(int signal) {
            return this.signals.contains(signal);
        }
    }
}

