/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.time.processors;

import io.intino.sumus.time.Magnitude;
import io.intino.sumus.time.Period;
import io.intino.sumus.time.Timeline;
import java.time.Instant;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.DoubleStream;

public class Resampler {
    private final Timeline timeline;
    private final Instant[] instants;
    private final Set<Magnitude> magnitudes;

    public Resampler(Timeline timeline) {
        this.timeline = timeline;
        this.instants = timeline.instants;
        this.magnitudes = timeline.measurements();
    }

    public Timeline execute(Period period, int size) {
        Timeline.Builder builder = new Timeline.Builder(size);
        Iterator<Instant> iterator = period.iterator(this.timeline.first().instant());
        Position from = new Position(iterator.next(), 0);
        while (!builder.isComplete()) {
            Position to = new Position(iterator.next(), from.index);
            this.execute(builder, from, to);
            from = to;
        }
        return builder.close();
    }

    private void execute(Timeline.Builder builder, Position from, Position to) {
        builder.set(from.instant);
        for (Magnitude magnitude : this.magnitudes) {
            builder.set(magnitude, this.reduce(magnitude, from, to));
        }
    }

    private double reduce(Magnitude magnitude, Position from, Position to) {
        return magnitude.reduce(this.streamOf(magnitude, from, to));
    }

    private DoubleStream streamOf(Magnitude magnitude, Position from, Position to) {
        Timeline.Point point = this.startingOn(from.instant);
        return point == null ? DoubleStream.empty() : point.forward().limit(to.index - from.index).mapToDouble(p -> p.value(magnitude));
    }

    private Timeline.Point startingOn(Instant instant) {
        return instant.isBefore(this.timeline.instants[0]) ? this.timeline.first() : this.timeline.at(instant);
    }

    private class Position {
        final Instant instant;
        final int index;

        Position(Instant instant, int index) {
            this.instant = instant;
            this.index = instant == null ? Resampler.this.instants.length : this.indexOf(instant, index);
        }

        private int indexOf(Instant instant, int index) {
            int i;
            for (i = index; i < Resampler.this.timeline.length() && Resampler.this.instants[i].isBefore(instant); ++i) {
            }
            return i;
        }

        public String toString() {
            return this.instant != null ? this.instant.toString() : "EOT";
        }
    }
}

