/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.time;

import io.intino.sumus.models.descriptive.timeseries.Distribution;
import io.intino.sumus.time.Filter;
import io.intino.sumus.time.Magnitude;
import io.intino.sumus.time.filters.Denoise;
import io.intino.sumus.time.filters.Differential;
import io.intino.sumus.time.filters.MovingAverage;
import io.intino.sumus.time.filters.Normalizer;
import io.intino.sumus.time.filters.RateOfGrowth;
import java.time.Instant;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class TimeSeries
implements Iterable<Point> {
    public final Magnitude.Model model;
    public final Instant[] instants;
    public final double[] values;
    private Distribution distribution;

    public TimeSeries(Magnitude.Model model, Instant[] instants, double[] values) {
        assert (instants.length == values.length);
        this.instants = instants;
        this.values = values;
        this.model = model;
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public int length() {
        return this.instants.length;
    }

    public boolean isBefore(TimeSeries timeSeries) {
        if (timeSeries.length() == 0) {
            return false;
        }
        return this.isEndOfTimes(timeSeries.firstInstant());
    }

    public boolean isAfter(TimeSeries timeSeries) {
        if (timeSeries.length() == 0) {
            return false;
        }
        return this.isBeginningOfTimes(timeSeries.lastInstant());
    }

    public String unit() {
        return this.model.unit;
    }

    public String symbol() {
        return this.model.symbol;
    }

    public double min() {
        return this.model.min;
    }

    public double max() {
        return this.model.max;
    }

    public Point first() {
        return this.point(0);
    }

    public Point last() {
        return this.point(this.lastIndex());
    }

    public Point at(Instant instant) {
        return this.point(this.indexOf(instant));
    }

    public TimeSeries head(int length) {
        return this.sub(0, this.limitHigh(length));
    }

    public TimeSeries tail(int length) {
        return this.sub(this.limitLow(this.length() - length), this.length());
    }

    public TimeSeries from(Instant instant) {
        if (this.isEndOfTimes(instant)) {
            return TimeSeries.empty();
        }
        return this.sub(this.indexOf(instant), this.length());
    }

    public TimeSeries from(Instant instant, int length) {
        if (this.isEndOfTimes(instant)) {
            return TimeSeries.empty();
        }
        int from = this.indexOf(instant);
        return length > 0 ? this.sub(from, this.limitHigh(from + length)) : this.sub(this.limitLow(from + 1 + length), this.limitHigh(from + 1));
    }

    public TimeSeries from(Instant instant, Instant to) {
        if (this.isEndOfTimes(instant)) {
            return TimeSeries.empty();
        }
        if (this.isEndOfTimes(to)) {
            return this.from(instant);
        }
        return this.sub(this.indexOf(instant), this.indexOf(to));
    }

    public TimeSeries to(Instant instant) {
        if (this.isEndOfTimes(instant)) {
            return this;
        }
        return this.sub(0, this.indexOf(instant));
    }

    private Point point(int index) {
        return this.isInRange(index) ? new Point(index) : null;
    }

    private boolean isBeginningOfTimes(Instant instant) {
        return this.firstInstant().isAfter(instant);
    }

    private boolean isEndOfTimes(Instant instant) {
        return this.lastInstant().isBefore(instant);
    }

    private boolean isInRange(int index) {
        return index >= 0 && index < this.length();
    }

    private int lastIndex() {
        return this.length() - 1;
    }

    private int limitLow(int offset) {
        return Math.max(0, offset);
    }

    private int limitHigh(int offset) {
        return Math.min(offset, this.length());
    }

    private Instant firstInstant() {
        return this.instants[0];
    }

    private Instant lastInstant() {
        return this.instants[this.lastIndex()];
    }

    private TimeSeries sub(int from, int to) {
        return this.isInRange(from) && this.isInRange(to - 1) ? new TimeSeries(Magnitude.Model.Default, this.instants(from, to), this.values(from, to)) : TimeSeries.empty();
    }

    public static TimeSeries empty() {
        return new TimeSeries(Magnitude.Model.Default, new Instant[0], new double[0]);
    }

    private int indexOf(Instant instant) {
        return Math.abs(Arrays.binarySearch(this.instants, instant));
    }

    private Instant[] instants(int from, int to) {
        return Arrays.copyOfRange(this.instants, from, to);
    }

    private double[] values(int from, int to) {
        return Arrays.copyOfRange(this.values, from, to);
    }

    @Override
    public Iterator<Point> iterator() {
        return new Iterator<Point>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < TimeSeries.this.instants.length;
            }

            @Override
            public Point next() {
                return new Point(this.index++);
            }
        };
    }

    public double sum() {
        return Arrays.stream(this.values).filter(v -> v == v).sum();
    }

    public double average() {
        return Arrays.stream(this.values).filter(v -> v == v).average().orElse(0.0);
    }

    public Distribution distribution() {
        if (this.distribution == null) {
            this.distribution = Distribution.of(this);
        }
        return this.distribution;
    }

    public TimeSeries concat(TimeSeries timeSeries) {
        assert (this.isBefore(timeSeries) && this.model.equals(timeSeries.model));
        return new TimeSeries(this.model, TimeSeries.concat(this.instants, timeSeries.instants), TimeSeries.concat(this.values, timeSeries.values));
    }

    static double[] concat(double[] a, double[] b) {
        double[] result = new double[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    static Instant[] concat(Instant[] a, Instant[] b) {
        Instant[] result = new Instant[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    public TimeSeries plus(TimeSeries series) {
        assert (Arrays.equals(this.instants, series.instants));
        return this.create(this.model, (a, b) -> Double.isNaN(a) ? b : (Double.isNaN(b) ? a : a + b), series);
    }

    public TimeSeries minus(TimeSeries series) {
        assert (Arrays.equals(this.instants, series.instants));
        return this.create(this.model, (a, b) -> Double.isNaN(a) ? b : (Double.isNaN(b) ? a : a - b), series);
    }

    public TimeSeries negate() {
        return this.times(-1.0);
    }

    public TimeSeries times(double factor) {
        return this.create(this.model, a -> a * factor);
    }

    public TimeSeries square() {
        return this.times(this);
    }

    public TimeSeries times(TimeSeries timeSeries) {
        return this.create(this.model, (a, b) -> a * b, timeSeries);
    }

    public TimeSeries dividedBy(TimeSeries series) {
        assert (Arrays.equals(this.instants, series.instants));
        return this.create(this.model, (a, b) -> Double.isNaN(a) ? b : (Double.isNaN(b) ? a : a / b), series);
    }

    public TimeSeries inverse() {
        Magnitude.Model model = this.model.symbol("1/" + this.model.symbol).unit("1/" + this.model.unit);
        return this.create(model, value -> value == 0.0 ? Double.NaN : 1.0 / value);
    }

    public TimeSeries differential() {
        return this.execute(Magnitude.Model.Default, new Differential());
    }

    public TimeSeries ratio() {
        return this.create(this.model.updateWith("max=1:symbol:unit"), value -> value / this.model.max);
    }

    public TimeSeries percentage() {
        return this.create(this.model.updateWith("max=100:unit:symbol=%"), value -> value * 100.0);
    }

    public TimeSeries rateOfGrowth() {
        return this.execute(Magnitude.Model.Default, new RateOfGrowth());
    }

    public TimeSeries abs() {
        return this.create(this.model, Math::abs);
    }

    public TimeSeries log() {
        return this.create(this.model, Math::log);
    }

    public TimeSeries movingAverage(int observations) {
        return this.execute(Magnitude.Model.Default, MovingAverage.of(observations));
    }

    public TimeSeries movingAverage(double smoothingFactor) {
        return this.execute(Magnitude.Model.Default, MovingAverage.of(smoothingFactor));
    }

    public TimeSeries denoise(Denoise.Mode mode) {
        return this.execute(Magnitude.Model.Default, new Denoise(mode));
    }

    public TimeSeries normalize() {
        return this.normalize(0.0, 1.0);
    }

    public TimeSeries normalize(double min, double max) {
        return this.execute(Magnitude.Model.Default, Normalizer.of(min, max));
    }

    public TimeSeries standardize() {
        return this.execute(Magnitude.Model.Default, Normalizer.standard());
    }

    public TimeSeries cumulativeMovingAverage(int period) {
        return this.average(1.0 / (double)period);
    }

    public TimeSeries exponentialMovingAverage(int period) {
        return this.average(2.0 / (double)(period + 1));
    }

    private TimeSeries average(double weight) {
        double[] result = new double[this.values.length];
        result[0] = this.average();
        for (int i = 1; i < this.values.length; ++i) {
            result[i] = this.values[i] * weight + result[i - 1] * (1.0 - weight);
        }
        return new TimeSeries(Magnitude.Model.Default, this.instants, result);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this == o || this.equals((TimeSeries)o);
    }

    private boolean equals(TimeSeries series) {
        return Arrays.equals(this.instants, series.instants) && Arrays.equals(this.values, series.values);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.instants);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.instants.length; ++i) {
            sb.append(this.instants[i]).append('\t').append(this.values[i]).append('\n');
        }
        return sb.toString();
    }

    private TimeSeries execute(Magnitude.Model model, Filter filter) {
        return new TimeSeries(model, this.instants, filter.calculate(this.values));
    }

    private TimeSeries create(Magnitude.Model model, Filter.UnaryOperator operator) {
        return this.execute(model, this.filterOf(operator));
    }

    private TimeSeries create(Magnitude.Model model, Filter.BinaryOperator operator, TimeSeries series) {
        return this.execute(model, this.filterOf(operator, series));
    }

    private Filter filterOf(Filter.UnaryOperator operator) {
        return values -> {
            double[] result = new double[this.instants.length];
            Arrays.setAll(result, i -> operator.calculate(values[i]));
            return result;
        };
    }

    private Filter filterOf(Filter.BinaryOperator operator, TimeSeries series) {
        return values -> {
            double[] result = new double[this.instants.length];
            Arrays.setAll(result, i -> operator.calculate(values[i], series.values[i]));
            return result;
        };
    }

    public class Point {
        private final int index;

        public Point(int index) {
            this.index = index;
        }

        public Instant instant() {
            return TimeSeries.this.instants[this.index];
        }

        public double value() {
            return TimeSeries.this.values[this.index];
        }

        public Stream<Point> forward() {
            return IntStream.range(this.index, TimeSeries.this.length()).mapToObj(x$0 -> TimeSeries.this.point(x$0));
        }

        public Stream<Point> backward() {
            return IntStream.iterate(this.index, i -> i >= 0, i -> i - 1).mapToObj(x$0 -> TimeSeries.this.point(x$0));
        }

        public String toString() {
            return TimeSeries.this.instants[this.index] + ":" + this.value();
        }

        public Point next() {
            return this.step(1);
        }

        public Point prev() {
            return this.step(-1);
        }

        public Point step(int value) {
            return TimeSeries.this.point(this.index + value);
        }
    }
}

