/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.time;

import com.github.luben.zstd.Zstd;
import io.intino.sumus.time.Magnitude;
import io.intino.sumus.time.Period;
import io.intino.sumus.time.Timeline;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ChronosFile {
    private final File file;
    private final Header header;
    private TimeModel timeModel;
    private SensorModel sensorModel;

    private ChronosFile(File file, String sensor) throws IOException {
        this.file = file;
        this.header = new Header(sensor);
        this.header.commit();
    }

    private ChronosFile(File file) throws IOException {
        this.file = file;
        this.header = new Header();
        if (file.exists()) {
            this.loadModels();
        }
    }

    public static ChronosFile create(String filename, String sensor) throws IOException {
        return ChronosFile.create(new File(filename), sensor);
    }

    public static ChronosFile create(File file, String sensor) throws IOException {
        if (file.exists()) {
            throw new IOException("File already exists");
        }
        return new ChronosFile(file, sensor);
    }

    public static ChronosFile open(String filename) throws IOException {
        return ChronosFile.open(new File(filename));
    }

    public static ChronosFile open(File file) throws IOException {
        if (!file.exists()) {
            throw new IOException("File does not exist");
        }
        return new ChronosFile(file);
    }

    public String id() {
        return this.header.sensor;
    }

    public int count() {
        return (int)this.header.count;
    }

    public Instant first() {
        return this.header.first;
    }

    public Instant last() {
        return this.header.last;
    }

    public Instant next() {
        return this.header.next;
    }

    public TimeModel timeModel() {
        return this.timeModel;
    }

    public SensorModel sensorModel() {
        return this.sensorModel;
    }

    public boolean compressed() {
        return this.header.compressed;
    }

    public ChronosFile compressed(boolean value) throws IOException {
        if (this.header.count > 0L) {
            throw new IllegalCallerException("Can not set compression of a file with data");
        }
        this.header.compressed = value;
        this.header.commit();
        return this;
    }

    public Timeline timeline() throws IOException {
        Query query = new Query();
        this.read(query);
        return query.close();
    }

    public void export(File file) throws IOException {
        try (ItlExporter exporter = new ItlExporter(file);){
            this.read(exporter);
        }
    }

    public ChronosFile timeModel(Instant instant, Period period) throws IOException {
        this.timeModel = new TimeModel(instant, period);
        this.updateHeader(instant);
        this.timeModel.commit();
        return this;
    }

    public ChronosFile sensorModel(String ... measurements) throws IOException {
        this.sensorModel = new SensorModel(measurements);
        this.updateHeader();
        this.sensorModel.commit();
        return this;
    }

    public ChronosFile sensorModel(Magnitude ... magnitudes) throws IOException {
        this.sensorModel = new SensorModel(magnitudes);
        this.updateHeader();
        this.sensorModel.commit();
        return this;
    }

    private void updateHeader(Instant instant) throws IOException {
        long position = this.file.length();
        this.header.setTimeModel(position, instant).commit();
    }

    private void updateHeader() throws IOException {
        this.header.setSensorModel(this.file.length()).commit();
    }

    public ChronosFile add(Timeline timeline) throws IOException {
        assert (this.last().getEpochSecond() <= timeline.first().instant().getEpochSecond());
        DataSession session = this.add();
        this.add(timeline, session);
        session.close();
        return this;
    }

    public DataSession add() throws IOException {
        if (this.timeModel == null) {
            throw new IllegalCallerException("It is not possible to add data without a time model");
        }
        if (this.sensorModel == null) {
            throw new IllegalCallerException("It is not possible to add data without a sensor model");
        }
        return new DataSession(this.outputStream());
    }

    private void add(Timeline timeline, DataSession session) throws IOException {
        for (Timeline.Point point : timeline) {
            session.set(point.instant());
            for (Magnitude magnitude : this.sensorModel) {
                session.set(magnitude, point.value(magnitude));
            }
        }
    }

    private void loadModels() throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(this.file, "r");){
            if (this.timeModelExists()) {
                this.timeModel = this.loadTimeModel(raf);
            }
            if (this.sensorModelExists()) {
                this.sensorModel = this.loadSensorModel(raf);
            }
        }
    }

    private boolean timeModelExists() {
        return this.header.timeModelPosition != 0L;
    }

    private boolean sensorModelExists() {
        return this.header.sensorModelPosition != 0L;
    }

    private Instant next(Instant instant) {
        return this.timeModel.next(instant);
    }

    private TimeModel loadTimeModel(RandomAccessFile raf) throws IOException {
        raf.seek(this.header.timeModelPosition);
        if (raf.readShort() != 26208) {
            throw new RuntimeException("Corrupted file at loading time model");
        }
        return new TimeModel(raf);
    }

    private SensorModel loadSensorModel(RandomAccessFile raf) throws IOException {
        raf.seek(this.header.sensorModelPosition);
        if (raf.readShort() != 26209) {
            throw new RuntimeException("Corrupted file at loading sensor model");
        }
        return new SensorModel(raf);
    }

    DataInputStream inputStream() throws IOException {
        return new DataInputStream(new BufferedInputStream(new FileInputStream(this.file)));
    }

    DataOutputStream outputStream() throws IOException {
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.file, true)));
    }

    private void read(Consumer<Block> consumer) throws IOException {
        new Reader(consumer).read();
    }

    public Fix fix(Instant instant) throws IOException {
        return new Fix(instant);
    }

    public Period period() {
        return this.timeModel.period;
    }

    private static void writeBigString(DataOutputStream output, String str) throws IOException {
        byte[] bytes = str.getBytes();
        output.writeInt(bytes.length);
        output.write(bytes);
    }

    private String readBigString(DataInputStream is) throws IOException {
        int length = is.readInt();
        byte[] bytes = new byte[length];
        int read = is.read(bytes);
        assert (read == length);
        return new String(bytes);
    }

    private static String readBigString(RandomAccessFile raf) throws IOException {
        int length = raf.readInt();
        byte[] bytes = new byte[length];
        int read = raf.read(bytes);
        assert (read == length);
        return new String(bytes);
    }

    public class Fix
    implements Closeable {
        private final RandomAccessFile raf;
        private final Instant instant;
        private final long position;

        public Fix(Instant instant) throws IOException {
            this.raf = new RandomAccessFile(ChronosFile.this.file, "rw");
            this.instant = instant;
            this.position = this.calculatePositionWith(this.steps());
        }

        private long calculatePositionWith(long steps) {
            if (steps < 0L) {
                throw new IllegalArgumentException("Fixing measurement: " + this.instant + " doesn't exist");
            }
            return this.checkSealing(ChronosFile.this.file.length() - steps * (6L + (long)ChronosFile.this.sensorModel.size() * 8L));
        }

        private long checkSealing(long result) {
            if (this.isSealed(result)) {
                throw new IllegalArgumentException("Fixing measurement: " + this.instant + " is already sealed");
            }
            return result;
        }

        private boolean isSealed(long result) {
            return result < ChronosFile.this.header.timeModelPosition || result < ChronosFile.this.header.sensorModelPosition;
        }

        private long steps() {
            return (ChronosFile.this.header.last.getEpochSecond() - this.instant.getEpochSecond()) / ChronosFile.this.timeModel().duration();
        }

        public Fix set(String measurement, double value) throws IOException {
            long index = ChronosFile.this.sensorModel.indexOf(new Magnitude(measurement));
            if (index < 0L) {
                throw new IllegalArgumentException("Fixing measurement: " + measurement + " doesn't exist");
            }
            this.raf.seek(this.position + index * 8L + 6L);
            this.raf.writeDouble(value);
            return this;
        }

        @Override
        public void close() throws IOException {
            this.raf.close();
        }
    }

    static class Stage {
        private double[] values = new double[this.size];
        private int size = 10;
        private int count = 0;

        public void set(double value) {
            this.values[this.count++] = value;
            if (this.count >= this.size) {
                this.values = this.resize();
            }
        }

        private double[] resize() {
            this.size += 10;
            double[] result = new double[this.size];
            System.arraycopy(this.values, 0, result, 0, this.values.length);
            return result;
        }

        public double[] values() {
            return Arrays.copyOfRange(this.values, 0, this.count);
        }

        public String toString() {
            return Arrays.toString(this.values);
        }
    }

    private static class Compressor {
        private static final byte[] buffer = new byte[32768];

        private Compressor() {
        }

        public static byte[] compress(byte[] data) {
            return Zstd.compress((byte[])data);
        }

        public static byte[] decompress(byte[] data) {
            long length = Zstd.decompress((byte[])buffer, (byte[])data);
            return Arrays.copyOf(buffer, (int)length);
        }
    }

    public class ItlExporter
    implements Consumer<Block>,
    Closeable {
        private final BufferedWriter output;
        private Period lastPeriod = null;
        private final DecimalFormat df = this.formatter();

        public ItlExporter(File file) throws IOException {
            this.output = new BufferedWriter(new FileWriter(file));
            this.output.write("@id " + ChronosFile.this.id() + "\n");
        }

        @Override
        public void accept(Block block) {
            try {
                if (block instanceof TimeModel) {
                    this.accept((TimeModel)block);
                }
                if (block instanceof SensorModel) {
                    this.accept((SensorModel)block);
                }
                if (block instanceof Data) {
                    this.accept((Data)block);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        private void accept(SensorModel data) throws IOException {
            this.output.write("@measurements " + String.join((CharSequence)",", data.magnitudes) + "\n");
        }

        @Override
        private void accept(TimeModel timeModel) throws IOException {
            this.output.write("@instant " + timeModel.instant.toString() + "\n");
            if (timeModel.period.equals((Object)this.lastPeriod)) {
                return;
            }
            this.output.write("@period " + timeModel.period + "\n");
            this.lastPeriod = timeModel.period;
        }

        @Override
        private void accept(Data data) throws IOException {
            this.output.write(this.toString(data.values) + "\n");
        }

        private String toString(double[] values) {
            return Arrays.stream(values).mapToObj(this::toString).collect(Collectors.joining("\t")).stripTrailing();
        }

        private String toString(double value) {
            return Double.isNaN(value) ? "" : this.format(value);
        }

        private String format(double value) {
            return Double.isNaN(value) ? "" : this.df.format(value);
        }

        private DecimalFormat formatter() {
            DecimalFormat df = new DecimalFormat("#.#############");
            df.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.ENGLISH));
            return df;
        }

        @Override
        public void close() throws IOException {
            this.output.close();
        }
    }

    public class Query
    extends Timeline.Builder
    implements Consumer<Block> {
        public Query() {
            super(ChronosFile.this.count());
        }

        @Override
        public void accept(Block block) {
            if (block instanceof Data) {
                this.accept((Data)block);
            }
        }

        @Override
        private void accept(Data data) {
            this.set(data.instant);
            for (Magnitude magnitude : ChronosFile.this.sensorModel) {
                this.set(magnitude, data.get(this.getIndexOf(magnitude)));
            }
        }

        private int getIndexOf(Magnitude magnitude) {
            return ChronosFile.this.sensorModel.indexOf(magnitude);
        }
    }

    public class Reader {
        private final Consumer<Block> consumer;
        private final Map<Short, BlockReader> readers;
        private TimeModel timeModel;
        private SensorModel sensorModel;
        private Instant instant;

        private Reader(Consumer<Block> consumer) {
            this.consumer = consumer;
            this.readers = this.readers();
            this.timeModel = null;
            this.sensorModel = null;
            this.instant = null;
        }

        private void read() throws IOException {
            try (DataInputStream is = ChronosFile.this.inputStream();){
                is.skipBytes(512);
                while (this.read(is) && is.available() != 0) {
                }
            }
        }

        private boolean read(DataInputStream is) throws IOException {
            short mark = is.readShort();
            if (!this.readers.containsKey(mark)) {
                throw new RuntimeException("Corrupted file");
            }
            this.readers.get(mark).process(is);
            return mark != -1;
        }

        private Map<Short, BlockReader> readers() {
            HashMap<Short, BlockReader> result = new HashMap<Short, BlockReader>();
            result.put(Block.NONE, this::skip);
            result.put((short)26208, this::readTimeModel);
            result.put((short)26209, this::readSensorModel);
            result.put((short)21845, this::readData);
            return result;
        }

        private void skip(DataInputStream is) {
        }

        private void readData(DataInputStream is) throws IOException {
            Data data = new Data(this.instant, new double[this.sensorModel.size()]);
            data.deserialize(this.readData(is, is.readInt()));
            this.consumer.accept(data);
            this.instant = ChronosFile.this.next(this.instant);
        }

        private byte[] readData(DataInputStream is, int size) throws IOException {
            byte[] bytes = new byte[size];
            int read = is.read(bytes);
            assert (read == size);
            return ChronosFile.this.header.compressed ? Compressor.decompress(bytes) : bytes;
        }

        private void readSensorModel(DataInputStream is) throws IOException {
            this.sensorModel = new SensorModel(ChronosFile.this.readBigString(is).split("\n"));
            this.consumer.accept(this.sensorModel);
        }

        private void readTimeModel(DataInputStream is) throws IOException {
            this.timeModel = new TimeModel(is.readLong(), is.readShort(), is.readShort());
            this.consumer.accept(this.timeModel);
            this.instant = this.timeModel.instant;
        }
    }

    public class DataSession {
        private final Stage[] stages;
        private DataOutputStream output;

        public DataSession(DataOutputStream os) {
            this.output = os;
            this.stages = new Stage[ChronosFile.this.sensorModel.size()];
        }

        public DataSession set(Instant instant) throws IOException {
            if (instant.isBefore(ChronosFile.this.next())) {
                return this;
            }
            if (this.hasStage()) {
                this.push();
            }
            this.saveTimeModel(instant, ChronosFile.this.timeModel.period);
            return this;
        }

        public DataSession set(String measurement, double value) {
            if (!ChronosFile.this.sensorModel.has(measurement)) {
                throw new IllegalArgumentException(measurement + " measurement is unknown");
            }
            return this.set(ChronosFile.this.sensorModel.get(measurement), value);
        }

        public DataSession set(Magnitude magnitude, double value) {
            if (!ChronosFile.this.sensorModel.has(magnitude)) {
                throw new IllegalArgumentException(magnitude + " measurement is unknown");
            }
            this.stageOf(magnitude).set(value);
            return this;
        }

        private void saveTimeModel(Instant instant, Period period) throws IOException {
            if (instant.isBefore(ChronosFile.this.next())) {
                return;
            }
            this.output.close();
            ChronosFile.this.timeModel(period.crop(instant), period);
            this.output = ChronosFile.this.outputStream();
        }

        public ChronosFile close() throws IOException {
            if (this.hasStage()) {
                this.push();
            }
            this.output.close();
            ChronosFile.this.header.commit();
            return ChronosFile.this;
        }

        private Stage stageOf(Magnitude magnitude) {
            Stage stage = this.stages[ChronosFile.this.sensorModel.indexOf(magnitude)];
            if (stage == null) {
                Stage stage2 = new Stage();
                this.stages[ChronosFile.this.sensorModel.indexOf((Magnitude)magnitude)] = stage2;
                stage = stage2;
            }
            return stage;
        }

        private void push() throws IOException {
            this.write(new Data(ChronosFile.this.last(), this.values()));
            ++ChronosFile.this.header.count;
            ChronosFile.this.header.step();
            Arrays.fill(this.stages, null);
        }

        private double[] values() {
            double[] result = new double[ChronosFile.this.sensorModel.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.stages[i] == null ? Double.NaN : this.measurement(i).reduce(this.values(i));
            }
            return result;
        }

        private double[] values(int i) {
            return this.stages[i].values();
        }

        private Magnitude measurement(int i) {
            return ChronosFile.this.sensorModel.magnitudes[i];
        }

        private void write(Data data) throws IOException {
            byte[] bytes = ChronosFile.this.header.compressed ? Compressor.compress(data.serialize()) : data.serialize();
            this.output.writeShort(21845);
            this.output.writeInt(bytes.length);
            this.output.write(bytes);
        }

        private boolean hasStage() {
            return Arrays.stream(this.stages).anyMatch(Objects::nonNull);
        }
    }

    public static class Data
    implements Block {
        static final short SIZE = 6;
        static final short MARK = 21845;
        public final Instant instant;
        public final double[] values;

        private Data(Instant instant, double[] values) {
            this.instant = instant;
            this.values = values;
        }

        public Instant instant() {
            return this.instant;
        }

        public double get(int index) {
            return this.values[index];
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public byte[] serialize() {
            try (ByteArrayOutputStream data = new ByteArrayOutputStream();){
                byte[] byArray;
                try (DataOutputStream os = new DataOutputStream(data);){
                    for (double value : this.values) {
                        os.writeDouble(value);
                    }
                    byArray = data.toByteArray();
                }
                return byArray;
            }
            catch (IOException ignored) {
                return new byte[0];
            }
        }

        public void deserialize(byte[] bytes) {
            try (DataInputStream is = new DataInputStream(new ByteArrayInputStream(bytes));){
                for (int i = 0; i < this.values.length; ++i) {
                    this.values[i] = is.readDouble();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public class SensorModel
    implements Block,
    Iterable<Magnitude> {
        static final short MARK = 26209;
        public final Magnitude[] magnitudes;
        public final Map<Magnitude, Integer> index = new HashMap<Magnitude, Integer>();

        private SensorModel(String ... measurements) {
            this((Magnitude[])Arrays.stream(measurements).map(Magnitude::new).toArray(Magnitude[]::new));
        }

        private SensorModel(Magnitude ... magnitudes) {
            this.magnitudes = magnitudes;
            this.index(magnitudes);
        }

        private SensorModel(RandomAccessFile raf) throws IOException {
            this(ChronosFile.readBigString(raf).split("\n"));
        }

        public Magnitude get(int i) {
            return i >= 0 ? this.magnitudes[i] : null;
        }

        public Magnitude get(String measurement) {
            return this.get(this.indexOf(new Magnitude(measurement)));
        }

        public int indexOf(Magnitude magnitude) {
            return this.index.getOrDefault(magnitude, -1);
        }

        public int size() {
            return this.magnitudes.length;
        }

        public boolean has(String measurement) {
            return this.index.containsKey(new Magnitude(measurement));
        }

        public boolean has(Magnitude magnitude) {
            return this.index.containsKey(magnitude);
        }

        private void index(Magnitude[] magnitudes) {
            for (int i = 0; i < magnitudes.length; ++i) {
                this.index.put(magnitudes[i], i);
            }
        }

        private void commit() throws IOException {
            try (DataOutputStream os = ChronosFile.this.outputStream();){
                this.writeIn(os);
            }
        }

        private void writeIn(DataOutputStream output) throws IOException {
            output.writeShort(26209);
            ChronosFile.writeBigString(output, String.join((CharSequence)"\n", this.magnitudes));
        }

        @Override
        public Iterator<Magnitude> iterator() {
            return new Iterator<Magnitude>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < SensorModel.this.size();
                }

                @Override
                public Magnitude next() {
                    return SensorModel.this.magnitudes[this.i++];
                }
            };
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this == o || Arrays.equals(this.magnitudes, ((SensorModel)o).magnitudes);
        }

        public int hashCode() {
            return Arrays.hashCode(this.magnitudes);
        }

        public String toString() {
            return Arrays.stream(this.magnitudes).map(Magnitude::toString).collect(Collectors.joining("\n"));
        }
    }

    public class TimeModel
    implements Block {
        static final short MARK = 26208;
        public final Instant instant;
        public final Period period;

        private TimeModel(Instant instant, Period period) {
            this.instant = instant;
            this.period = period;
        }

        private TimeModel(RandomAccessFile raf) throws IOException {
            this(raf.readLong(), raf.readShort(), raf.readShort());
        }

        private TimeModel(long instant, short amount, short chronoUnit) {
            this(Instant.ofEpochMilli(instant), Period.each(amount, chronoUnit));
        }

        private void commit() throws IOException {
            try (DataOutputStream os = ChronosFile.this.outputStream();){
                this.writeIn(os);
            }
        }

        private void writeIn(DataOutputStream output) throws IOException {
            output.writeShort(26208);
            output.writeLong(this.instant.toEpochMilli());
            output.writeShort(this.period.amount);
            output.writeShort(this.period.unit.ordinal());
        }

        public ChronoUnit unit() {
            return this.period.unit;
        }

        public long duration() {
            return this.period.duration();
        }

        public Instant next(Instant instant) {
            return this.period.next(instant);
        }

        public String toString() {
            return "from " + this.instant + " each " + this.period;
        }
    }

    private static interface BlockReader {
        public void process(DataInputStream var1) throws IOException;
    }

    private static interface Block {
        public static final Short NONE = -1;
    }

    private class Header {
        private static final short MARK = 20485;
        private static final int SIZE = 512;
        private final String sensor;
        private boolean compressed;
        private long sensorModelPosition;
        private long timeModelPosition;
        private long count;
        private Instant first;
        private Instant last;
        private Instant next;

        private Header(String sensor) {
            this.sensor = sensor;
            this.sensorModelPosition = 0L;
            this.timeModelPosition = 0L;
            this.count = 0L;
            this.compressed = false;
            this.first = Instant.EPOCH;
            this.next = Instant.EPOCH;
            this.last = Instant.EPOCH;
        }

        private Header() throws IOException {
            try (DataInputStream is = ChronosFile.this.inputStream();){
                if (is.readShort() != 20485) {
                    throw new RuntimeException("Corrupted file");
                }
                this.count = is.readLong();
                this.sensorModelPosition = is.readLong();
                this.timeModelPosition = is.readLong();
                this.first = Instant.ofEpochMilli(is.readLong());
                this.last = Instant.ofEpochMilli(is.readLong());
                this.next = Instant.ofEpochMilli(is.readLong());
                this.compressed = is.readBoolean();
                this.sensor = is.readUTF();
            }
        }

        private void commit() throws IOException {
            boolean fileExists = ChronosFile.this.file.exists();
            try (RandomAccessFile raf = new RandomAccessFile(ChronosFile.this.file, "rw");){
                raf.seek(0L);
                raf.writeShort(20485);
                raf.writeLong(this.count);
                raf.writeLong(this.sensorModelPosition);
                raf.writeLong(this.timeModelPosition);
                raf.writeLong(this.first.toEpochMilli());
                raf.writeLong(this.last.toEpochMilli());
                raf.writeLong(this.next.toEpochMilli());
                raf.writeBoolean(this.compressed);
                if (fileExists) {
                    return;
                }
                raf.writeUTF(this.sensor);
                raf.write(this.fill(raf));
            }
        }

        private byte[] fill(RandomAccessFile raf) throws IOException {
            return new byte[(int)(512L - raf.length())];
        }

        Header setTimeModel(long position, Instant last) {
            this.first = this.isFirstTimeModel() ? last : this.first;
            this.last = last;
            this.next = ChronosFile.this.timeModel().next(last);
            this.timeModelPosition = position;
            return this;
        }

        Header setSensorModel(long position) {
            this.sensorModelPosition = position;
            return this;
        }

        void step() {
            this.last = this.next;
            this.next = ChronosFile.this.timeModel.next(this.last);
        }

        private boolean isFirstTimeModel() {
            return this.timeModelPosition == 0L;
        }
    }
}

