/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.models.descriptive.sequence;

import io.intino.sumus.models.descriptive.sequence.Sequence;
import java.util.Arrays;
import java.util.stream.IntStream;

public class TransitionGraph {
    private final Sequence sequence;
    private final int[][] transitions;
    private int last = -1;

    public static TransitionGraph of(Sequence sequence) {
        TransitionGraph graph = new TransitionGraph(sequence.symbols());
        for (Sequence.Point point : sequence) {
            graph.put(point.token());
        }
        return graph;
    }

    private void put(int value) {
        if (this.last >= 0) {
            int[] nArray = this.transitions[this.last];
            int n = value;
            nArray[n] = nArray[n] + 1;
        }
        this.last = value;
    }

    private TransitionGraph(String[] states) {
        this.sequence = Sequence.of(states);
        this.transitions = new int[states.length][states.length];
    }

    public int size() {
        return this.sequence.symbols().length;
    }

    public String[] states() {
        return this.sequence.symbols();
    }

    private double[] stateProbabilities() {
        int i;
        double[] result = new double[this.size()];
        double total = 0.0;
        for (i = 0; i < this.size(); ++i) {
            for (int j = 0; j < this.size(); ++j) {
                int n = i;
                result[n] = result[n] + (double)this.transitions[i][j];
                total += (double)this.transitions[i][j];
            }
        }
        if (total == 0.0) {
            return result;
        }
        for (i = 0; i < this.size(); ++i) {
            result[i] = result[i] / total;
        }
        return result;
    }

    public int[][] transitions() {
        return this.transitions;
    }

    public int[] transitions(String state) {
        return this.transitions[this.sequence.indexOf(state)];
    }

    public double[][] transitionProbabilities() {
        double[][] result = new double[this.size()][];
        for (int row = 0; row < this.size(); ++row) {
            result[row] = this.transitionProbabilities(row);
        }
        return result;
    }

    public double[] transitionProbabilities(String state) {
        return this.transitionProbabilities(this.sequence.indexOf(state));
    }

    private double[] transitionProbabilities(int row) {
        double[] result = new double[this.size()];
        double sum = this.sum(row);
        for (int i = 0; i < this.size(); ++i) {
            result[i] = sum > 0.0 ? (double)this.transitions[row][i] / sum : (i == row ? 1.0 : 0.0);
        }
        return result;
    }

    public double[] walk(int steps) {
        double[] stateProbabilities = this.stateProbabilities();
        double[][] randomWalks = this.power(this.transitionProbabilities(), steps);
        double[] result = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            for (int j = 0; j < this.size(); ++j) {
                int n = j;
                result[n] = result[n] + stateProbabilities[i] * randomWalks[i][j];
            }
        }
        return result;
    }

    private double[][] power(double[][] matrix, int steps) {
        double[][] result = matrix;
        for (int i = 1; i < steps; ++i) {
            result = this.multiply(result, matrix);
        }
        return result;
    }

    private double[][] multiply(double[][] a, double[][] b) {
        double[][] c = new double[this.size()][this.size()];
        IntStream.range(0, this.size()).parallel().forEach(i -> {
            for (int k = 0; k < this.size(); ++k) {
                for (int j = 0; j < this.size(); ++j) {
                    double[] dArray = c[i];
                    int n = j;
                    dArray[n] = dArray[n] + a[i][k] * b[k][j];
                }
            }
        });
        return c;
    }

    private int sum(int row) {
        return Arrays.stream(this.transitions[row]).sum();
    }
}

