/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries.tdigest;

import io.intino.alexandria.ui.model.TimeScale;
import io.intino.sumus.graph.Distribution;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.queries.Drill;
import io.intino.sumus.queries.Filter;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Query {
    private final Set<Distribution.Source> sources = new HashSet<Distribution.Source>();
    private final List<Drill> drills = new ArrayList<Drill>();
    private final Instant instant;
    private final TimeScale scale;
    private NameSpace nameSpace;
    private Filter filter;

    public Query(Instant instant, TimeScale scale, NameSpace nameSpace) {
        this.instant = instant;
        this.scale = scale;
        this.nameSpace = nameSpace;
    }

    public Instant instant() {
        return this.instant;
    }

    public TimeScale scale() {
        return this.scale;
    }

    public NameSpace nameSpace() {
        return this.nameSpace;
    }

    public List<Distribution.Source> sources() {
        return new ArrayList<Distribution.Source>(this.sources);
    }

    public List<Drill> drills() {
        return this.drills;
    }

    public Filter filter() {
        return this.filter;
    }

    public Query source(Distribution.Source ... sources) {
        Collections.addAll(this.sources, sources);
        return this;
    }

    public Drill drill(List<String> tags) {
        Drill drill = new Drill("drill" + this.drills.size(), tags);
        this.drills.add(drill);
        return drill;
    }

    public Query filter(List<String> tags) {
        this.filter = this.filter == null ? new Filter() : this.filter;
        this.filter.addTags(tags);
        return this;
    }
}

