/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries.digest;

import io.intino.alexandria.ui.model.TimeRange;
import io.intino.alexandria.ui.model.TimeScale;
import io.intino.sumus.TimeStamp;
import io.intino.sumus.graph.Cube;
import io.intino.sumus.graph.MeasureIndicator;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.queries.Drill;
import io.intino.sumus.queries.Filter;
import java.time.Instant;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Query {
    private final Map<String, SubQuery> subQueries = new LinkedHashMap<String, SubQuery>();
    private final Set<TimeStamp> ts = new LinkedHashSet<TimeStamp>();
    private final Set<Drill> drills = new LinkedHashSet<Drill>();
    private final Map<TimeStamp, List<Drill>> temporalDrills = new HashMap<TimeStamp, List<Drill>>();
    private int drillCount = 0;
    private Filter filter;

    private static String id(NameSpace nameSpace, MeasureIndicator.Formula formula) {
        return nameSpace.name$() + formula.name$();
    }

    private static Set<TimeStamp> timeStampsOf(TimeRange range) {
        HashSet<TimeStamp> stamps = new HashSet<TimeStamp>();
        Instant instant = range.scale().normalise(range.from());
        while (instant.isBefore(range.to())) {
            stamps.add(Query.timeStampOf(instant, range.scale()));
            instant = range.scale().nextTime(instant);
        }
        return stamps;
    }

    private static TimeStamp timeStampOf(Instant instant, TimeScale scale) {
        return new TimeStamp(instant, scale);
    }

    public Query add(NameSpace nameSpace, MeasureIndicator.Formula formula) {
        if (!this.subQueries.containsKey(Query.id(nameSpace, formula))) {
            this.subQueries.put(Query.id(nameSpace, formula), new SubQuery(nameSpace, formula, new HashSet<TimeStamp>()));
        }
        return this;
    }

    public Query add(NameSpace nameSpace, MeasureIndicator.Formula formula, TimeRange range) {
        this.add(nameSpace, formula);
        this.subQueries.get(Query.id(nameSpace, formula)).add(Query.timeStampsOf(range));
        return this;
    }

    public Query add(NameSpace nameSpace, MeasureIndicator.Formula formula, Instant instant, TimeScale scale) {
        this.add(nameSpace, formula);
        this.subQueries.get(Query.id(nameSpace, formula)).add(Query.timeStampOf(instant, scale));
        return this;
    }

    public Query add(TimeRange timeRange) {
        this.ts.addAll(Query.timeStampsOf(timeRange));
        return this;
    }

    public Query add(Instant instant, TimeScale scale) {
        this.ts.add(Query.timeStampOf(instant, scale));
        return this;
    }

    public Query add(TimeStamp timeStamp) {
        this.ts.add(timeStamp);
        return this;
    }

    public Query drill(Collection<String> tags) {
        this.drills.add(new Drill("label" + this.drillCount++, tags));
        return this;
    }

    public Query drill(String tag) {
        this.drills.add(new Drill("label" + this.drillCount++, Collections.singletonList(tag)));
        return this;
    }

    private void processTemporalDrill(Drill drill) {
        if (!this.temporalDrills.containsKey(drill.timeStamp())) {
            this.temporalDrills.put(drill.timeStamp(), new ArrayList());
        }
        this.temporalDrills.get(drill.timeStamp()).add(drill);
    }

    public Query filter(List<String> tags) {
        this.filter = this.filter == null ? new Filter() : this.filter;
        this.filter.addTags(tags);
        return this;
    }

    public Query drill(TimeStamp timeStamp) {
        Drill drill = new Drill("label" + this.drillCount++, timeStamp);
        this.processTemporalDrill(drill);
        return this;
    }

    public Query filter(TimeStamp timeStamps) {
        this.filter = this.filter == null ? new Filter() : this.filter;
        this.filter.addTimeStamp(timeStamps);
        return this;
    }

    public List<NameSpace> nameSpaces() {
        return new ArrayList<NameSpace>(this.subQueries.values().stream().map(s -> s.nameSpace).collect(LinkedHashSet::new, HashSet::add, AbstractCollection::addAll));
    }

    public List<MeasureIndicator.Formula> formulas() {
        return new ArrayList<MeasureIndicator.Formula>(this.subQueries.values().stream().map(s -> s.formula).collect(LinkedHashSet::new, HashSet::add, AbstractCollection::addAll));
    }

    public Collection<SubQuery> subQueries() {
        return this.subQueries.values();
    }

    SubQuery subQuery(NameSpace nameSpace, MeasureIndicator.Formula formula) {
        return this.subQueries.get(Query.id(nameSpace, formula));
    }

    public List<TimeStamp> timeStamps() {
        return new ArrayList<TimeStamp>(this.ts);
    }

    public List<TimeStamp> timeStamps(NameSpace nameSpace, MeasureIndicator.Formula formula) {
        return new ArrayList<TimeStamp>(this.subQueries.get(Query.id(nameSpace, formula)).timeStamps());
    }

    public List<Drill> drills() {
        return new ArrayList<Drill>(this.drills);
    }

    public Filter filter() {
        return this.filter;
    }

    public List<Drill> drills(TimeStamp timeStamp) {
        return this.temporalDrills.get(timeStamp);
    }

    Query commit() {
        Set<TimeStamp> ts = this.filteredStamps(this.queryTimeStamps());
        for (SubQuery subQuery : this.subQueries.values()) {
            this.commit(subQuery, ts);
        }
        return this;
    }

    private Set<TimeStamp> queryTimeStamps() {
        for (TimeStamp ts : this.temporalDrills.keySet()) {
            this.add(ts);
        }
        return this.ts;
    }

    private Set<TimeStamp> filteredStamps(Set<TimeStamp> ts) {
        if (this.filter == null || !this.filter.isTemporal()) {
            return ts;
        }
        ArrayList<TimeStamp> toRemove = new ArrayList<TimeStamp>();
        for (TimeStamp t : ts) {
            if (this.filter.contains(t)) continue;
            toRemove.add(t);
        }
        ts.removeAll(toRemove);
        return ts;
    }

    private void commit(SubQuery subQuery, Set<TimeStamp> ts) {
        subQuery.ts = this.filteredStamps(subQuery.ts);
        subQuery.ts.addAll(ts);
    }

    class SubQuery {
        NameSpace nameSpace;
        MeasureIndicator.Formula formula;
        Set<TimeStamp> ts;

        SubQuery(NameSpace nameSpace, MeasureIndicator.Formula formula, Set<TimeStamp> ts) {
            this.nameSpace = nameSpace;
            this.formula = formula;
            this.ts = ts;
        }

        void add(Set<TimeStamp> timeStamps) {
            this.ts.addAll(timeStamps);
        }

        void add(TimeStamp timeStamp) {
            this.ts.add(timeStamp);
        }

        Set<TimeStamp> timeStamps() {
            HashSet<TimeStamp> stamps = new HashSet<TimeStamp>(this.ts);
            stamps.addAll(Query.this.ts);
            return stamps;
        }

        Cube cube() {
            return this.formula.cube();
        }

        public String toString() {
            return Query.id(this.nameSpace, this.formula);
        }
    }
}

