/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries;

import io.intino.alexandria.ui.model.TimeRange;
import io.intino.alexandria.ui.model.TimeScale;
import io.intino.alexandria.ui.services.push.User;
import io.intino.sumus.analytics.viewmodels.FilterCondition;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.queries.AbstractQuery;
import io.intino.sumus.queries.temporalrecord.Query;
import io.intino.tara.magritte.Concept;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TemporalRecordQuery
extends AbstractQuery {
    private Concept record;
    private Map<Categorization, List<String>> filters = new HashMap<Categorization, List<String>>();
    private String condition;
    private TimeRange range = null;
    private TimeScale scale = null;
    private Instant instant = null;
    private NameSpace nameSpace;
    private User user;

    private TemporalRecordQuery() {
    }

    public Concept record() {
        return this.record;
    }

    public String condition() {
        return this.condition;
    }

    public TimeRange timeRange() {
        return this.range;
    }

    public Map<Categorization, List<String>> filters() {
        return this.filters;
    }

    public NameSpace nameSpace() {
        return this.nameSpace;
    }

    public User user() {
        return this.user;
    }

    public Query toRawQuery() {
        Query result = this.range != null ? new Query(this.nameSpace, this.record, this.range) : new Query(this.nameSpace, this.record, this.scale, this.instant);
        this.addScope(result);
        if (this.condition != null) {
            result.condition(this.condition);
        }
        this.filters().values().forEach(result::filter);
        return result;
    }

    public static class Builder
    extends AbstractQuery.Builder<TemporalRecordQuery> {
        public Builder() {
            super(new TemporalRecordQuery());
        }

        public TemporalRecordQuery build(Concept record, User user) {
            ((TemporalRecordQuery)this.query).record = record;
            ((TemporalRecordQuery)this.query).user = user;
            return (TemporalRecordQuery)this.query;
        }

        public Builder nameSpace(NameSpace nameSpace) {
            ((TemporalRecordQuery)this.query).nameSpace = nameSpace;
            return this;
        }

        public Builder timeRange(TimeRange range) {
            ((TemporalRecordQuery)this.query).range = range;
            return this;
        }

        public Builder instant(Instant instant, TimeScale scale) {
            ((TemporalRecordQuery)this.query).instant = instant;
            ((TemporalRecordQuery)this.query).scale = scale;
            return this;
        }

        public Builder filter(List<FilterCondition> filters) {
            ((TemporalRecordQuery)this.query).filters = ((TemporalRecordQuery)this.query).toMap(filters);
            return this;
        }

        public Builder condition(String condition) {
            ((TemporalRecordQuery)this.query).condition = condition;
            return this;
        }
    }
}

