/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.helpers;

import io.intino.alexandria.ui.services.push.UISession;
import io.intino.alexandria.ui.services.push.User;
import io.intino.sumus.SumusStore;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.SumusGraph;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class NameSpaceHandler {
    private final SumusGraph graph;
    private Map<String, NameSpace> selection = new HashMap<String, NameSpace>();
    private List<Consumer<NameSpace>> listeners = new ArrayList<Consumer<NameSpace>>();

    public NameSpaceHandler(SumusGraph graph) {
        this.graph = graph;
    }

    public void onSelect(Consumer<NameSpace> listener) {
        this.listeners.add(listener);
    }

    public void removeSelectListener(Consumer<NameSpace> listener) {
        this.listeners.remove(listener);
    }

    public NameSpace selectedNameSpace(UISession session) {
        List<NameSpace> nameSpaces;
        String id = this.idOf(session);
        if (!this.selection.containsKey(id) && (nameSpaces = this.nameSpaces(session.user())).size() > 0) {
            this.selection.put(id, nameSpaces.get(0));
        }
        return this.selection.get(id);
    }

    public NameSpaceHandler select(UISession session, String key) {
        this.select(session, (NameSpace)this.nameSpaces(session.user()).stream().filter(n -> n.name$().equals(key) || n.label().equals(key)).findFirst().orElse(null));
        return this;
    }

    public NameSpaceHandler select(UISession session, NameSpace nameSpace) {
        this.selection.put(this.idOf(session), nameSpace);
        this.clearNameSpaceRanges();
        this.listeners.forEach(l -> l.accept(nameSpace));
        return this;
    }

    private String idOf(UISession session) {
        return session.user() != null ? session.user().username() : session.id();
    }

    public List<NameSpace> nameSpaces(User user) {
        return this.graph.nameSpaces(user);
    }

    private void clearNameSpaceRanges() {
        SumusStore store = (SumusStore)this.graph.core$().store();
        store.clearNameSpaceRanges();
    }
}

