/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.helpers;

import io.intino.alexandria.ui.services.push.User;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.graph.Entity;
import io.intino.sumus.helpers.Helper;
import io.intino.sumus.queries.EntityQuery;
import io.intino.sumus.queries.Scope;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class EntityHelper
extends Helper {
    private final SumusBox box;

    public EntityHelper(SumusBox box) {
        this.box = box;
    }

    public List<Entity> entities(EntityQuery query) {
        Concept entity = query.entity();
        Optional<Scope> scope = query.scope();
        if (!scope.isPresent()) {
            return Collections.emptyList();
        }
        List layers = this.box.graph().core$().find(entity.layerClass());
        List lists = scope.get().tagsMap().keySet().stream().map(s -> this.recordsOfCategorization((String)s, layers, ((Scope)scope.get()).tagsMap().get(s))).collect(Collectors.toList());
        return layers.stream().filter(l -> lists.stream().allMatch(list -> list.contains(l.core$().id()))).map(l -> (Entity)l.a$(Entity.class)).filter(e -> this.hasCondition((Layer)e, query.condition())).collect(Collectors.toList());
    }

    private Set<String> recordsOfCategorization(String categorization, List<? extends Layer> layers, List<String> tags) {
        if (layers.isEmpty()) {
            return Collections.emptySet();
        }
        return this.box.graph().categorizationList(c -> c.name$().equals(categorization)).findFirst().get().categorizedLayersMap(layers).entrySet().stream().filter(e -> tags.contains(e.getKey())).map(Map.Entry::getValue).flatMap(Collection::stream).map(l -> l.core$().id()).collect(Collectors.toSet());
    }

    public Entity entity(String id, User user) {
        Node node = this.box.graph().core$().clone().load(id, false);
        if (node == null) {
            return null;
        }
        return (Entity)node.as(Entity.class);
    }

    private boolean hasCondition(Layer entity, String condition) {
        if (condition == null || condition.isEmpty()) {
            return true;
        }
        List<String> keys = Arrays.asList(this.clean(condition).split(" "));
        List<String> words = this.words(entity);
        return keys.stream().filter(key -> words.stream().filter(word -> word.contains((CharSequence)key)).count() > 0L).count() == (long)keys.size();
    }

    private List<String> words(Layer entity) {
        return this.words(entity, 0);
    }

    private List<String> words(Layer entity, int depth) {
        if (depth == 2) {
            return Collections.emptyList();
        }
        List values = entity.core$().variables().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        List<String> words = values.stream().filter(v -> v instanceof String).map(v -> this.clean((String)v)).collect(Collectors.toList());
        values.stream().filter(v -> v instanceof Layer).map(v -> (Layer)v).forEach(e -> words.addAll(this.words((Layer)e, depth + 1)));
        return words;
    }

    private String clean(String value) {
        return Normalizer.normalize(value.toLowerCase(), Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
    }
}

