/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.helpers;

import io.intino.alexandria.ui.model.TimeRange;
import io.intino.sumus.analytics.viewmodels.Drill;
import io.intino.sumus.analytics.viewmodels.FilterCondition;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.queries.Scope;
import io.intino.tara.magritte.Concept;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ChartSpec {
    private List<Ticket> ticketList = new LinkedList<Ticket>();
    private Map<Ticket, List<String>> ticketTags = new HashMap<Ticket, List<String>>();
    private List<Categorization> categorizationList = new LinkedList<Categorization>();
    private Map<Categorization, List<String>> categorizationTags = new HashMap<Categorization, List<String>>();
    private List<FilterCondition> filterConditionList = new LinkedList<FilterCondition>();
    private List<Concept> eventTypeList = new ArrayList<Concept>();
    private Drill drill = null;
    private TimeRange range = null;
    private boolean includeGlobalSerie = true;
    private HeatMap heatMap = null;
    private Scope scope = null;

    public Scope scope() {
        return this.scope;
    }

    public void scope(Scope scope) {
        this.scope = scope;
    }

    public List<Ticket> ticketList() {
        return this.ticketList;
    }

    public List<Ticket> ticketList(String tag) {
        return this.ticketTags.entrySet().stream().filter(entry -> {
            Ticket ticket = (Ticket)((Object)((Object)entry.getKey()));
            return ((List)entry.getValue()).contains(tag) && this.ticketList.contains((Object)ticket);
        }).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public void clearTicketsTag(String tag) {
        this.ticketTags.values().forEach(tt -> tt.remove(tag));
    }

    public void clearTags(Ticket ticket) {
        if (!this.ticketTags.containsKey((Object)ticket)) {
            return;
        }
        this.ticketTags.clear();
    }

    public void addTags(Ticket ticket, List<String> tagList) {
        if (!this.ticketTags.containsKey((Object)ticket)) {
            this.ticketTags.put(ticket, new ArrayList());
        }
        this.ticketTags.get((Object)ticket).addAll(tagList);
    }

    public List<Categorization> categorizationList() {
        return this.categorizationList;
    }

    public List<Categorization> categorizationList(String tag) {
        return this.categorizationTags.entrySet().stream().filter(entry -> {
            Categorization categorization = (Categorization)((Object)((Object)entry.getKey()));
            return ((List)entry.getValue()).contains(tag) && this.categorizationList.contains((Object)categorization);
        }).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public void clearCategorizationsTag(String tag) {
        this.categorizationTags.values().forEach(ct -> ct.remove(tag));
    }

    public void addTags(Categorization categorization, List<String> tagList) {
        if (!this.categorizationTags.containsKey((Object)categorization)) {
            this.categorizationTags.put(categorization, new ArrayList());
        }
        this.categorizationTags.get((Object)categorization).addAll(tagList);
    }

    public Drill drill() {
        return this.drill;
    }

    public boolean includeGlobalSerie() {
        return this.includeGlobalSerie;
    }

    public void drill(Drill drill) {
        this.drill = drill;
    }

    public void drill(Drill drill, boolean includeGlobalSerie) {
        this.drill = drill;
        this.includeGlobalSerie = includeGlobalSerie;
    }

    public List<FilterCondition> filterList() {
        return this.filterConditionList;
    }

    public TimeRange range() {
        return this.range;
    }

    public void range(TimeRange range) {
        this.range = range;
    }

    public HeatMap heatMap() {
        return this.heatMap;
    }

    public void heatMap(HeatMap heatMap) {
        this.heatMap = heatMap;
    }

    public List<Concept> eventTypes() {
        return this.eventTypeList;
    }

    public void eventTypes(List<Concept> eventTypeList) {
        this.eventTypeList = eventTypeList;
    }

    public boolean equals(ChartSpec spec) {
        if (!this.equalsTickets(spec.ticketList())) {
            return false;
        }
        if (!this.equalsCategorizations(spec.categorizationList())) {
            return false;
        }
        if (!this.equalsFilters(spec.filterList())) {
            return false;
        }
        if (!this.equalsDrill(spec.drill())) {
            return false;
        }
        return this.equalsRange(spec.range());
    }

    public boolean equalsTickets(List<Ticket> ticketList) {
        if (ticketList.size() != this.ticketList.size()) {
            return false;
        }
        for (int i = 0; i < ticketList.size(); ++i) {
            Ticket ticket = ticketList.get(i);
            Ticket currentTicket = this.ticketList.get(i);
            if (ticket.name$().equals(currentTicket.name$())) continue;
            return false;
        }
        return true;
    }

    public boolean equalsCategorizations(List<Categorization> categorizationList) {
        if (categorizationList.size() != this.categorizationList.size()) {
            return false;
        }
        for (int i = 0; i < categorizationList.size(); ++i) {
            Categorization categorization = categorizationList.get(i);
            Categorization currentCategorization = this.categorizationList.get(i);
            if (categorization.name$().equals(currentCategorization.name$())) continue;
            return false;
        }
        return true;
    }

    public boolean equalsFilters(List<FilterCondition> filterConditionList) {
        if (filterConditionList.size() != this.filterConditionList.size()) {
            return false;
        }
        for (int i = 0; i < filterConditionList.size(); ++i) {
            FilterCondition currentFilterCondition;
            FilterCondition condition = filterConditionList.get(i);
            if (condition == (currentFilterCondition = this.filterConditionList.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equalsDrill(Drill drill) {
        if (drill == null && this.drill == null) {
            return true;
        }
        if (drill == null) {
            return false;
        }
        if (this.drill == null) {
            return false;
        }
        return drill.categorization == this.drill.categorization && drill.tags.size() == this.drill.tags.size();
    }

    public boolean equalsRange(TimeRange range) {
        if (this.range == null && range == null) {
            return true;
        }
        if (this.range == null || range == null) {
            return false;
        }
        if (this.range.scale() != range.scale()) {
            return false;
        }
        if (this.range.from() != range.from()) {
            return false;
        }
        return this.range.to() == range.to();
    }

    public static interface HeatMap {
        public String minColor();

        public String maxColor();
    }
}

