/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.alexandria.ui.model.Catalog;
import io.intino.sumus.CatalogList;
import io.intino.sumus.graph.AbstractAccess;
import io.intino.sumus.graph.AbstractMetric;
import io.intino.sumus.graph.Access;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Checker;
import io.intino.sumus.graph.Cluster;
import io.intino.sumus.graph.Cube;
import io.intino.sumus.graph.Element;
import io.intino.sumus.graph.Entity;
import io.intino.sumus.graph.Episode;
import io.intino.sumus.graph.Event;
import io.intino.sumus.graph.Filter;
import io.intino.sumus.graph.GlobalAccess;
import io.intino.sumus.graph.Metric;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Olap;
import io.intino.sumus.graph.OnClickInstant;
import io.intino.sumus.graph.Palette;
import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.Report;
import io.intino.sumus.graph.TemporalMetric;
import io.intino.sumus.graph.TemporalRecord;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.graph.aspect.AspectEntity;
import io.intino.sumus.graph.dynamic.DynamicEntity;
import io.intino.sumus.graph.functions.NameSpacesLoader;
import io.intino.sumus.graph.geolocated.GeolocatedEntity;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Expression;
import io.intino.tara.magritte.Graph;
import io.intino.tara.magritte.GraphWrapper;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.utils.I18n;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class AbstractGraph
extends GraphWrapper {
    protected Graph graph;
    private List<Ticket> ticketList = new ArrayList<Ticket>();
    private List<Olap> olapList = new ArrayList<Olap>();
    private List<Filter> filterList = new ArrayList<Filter>();
    private List<OnClickInstant> onClickInstantList = new ArrayList<OnClickInstant>();
    private Palette palette;
    private List<Element> elementList = new ArrayList<Element>();
    private List<Cluster> clusterList = new ArrayList<Cluster>();
    private List<Record> recordList = new ArrayList<Record>();
    private List<TemporalRecord> temporalRecordList = new ArrayList<TemporalRecord>();
    private List<Entity> entityList = new ArrayList<Entity>();
    private List<Event> eventList = new ArrayList<Event>();
    private List<Episode> episodeList = new ArrayList<Episode>();
    private List<Report> reportList = new ArrayList<Report>();
    private List<Cube> cubeList = new ArrayList<Cube>();
    private List<Checker> checkerList = new ArrayList<Checker>();
    private List<GeolocatedEntity> geolocatedEntityList = new ArrayList<GeolocatedEntity>();
    private List<DynamicEntity> dynamicEntityList = new ArrayList<DynamicEntity>();
    private List<AspectEntity> aspectEntityList = new ArrayList<AspectEntity>();
    private List<AbstractAccess> abstractAccessList = new ArrayList<AbstractAccess>();
    private List<Access> accessList = new ArrayList<Access>();
    private List<GlobalAccess> globalAccessList = new ArrayList<GlobalAccess>();
    private List<Categorization> categorizationList = new ArrayList<Categorization>();
    private List<AbstractMetric> abstractMetricList = new ArrayList<AbstractMetric>();
    private List<Metric> metricList = new ArrayList<Metric>();
    private List<TemporalMetric> temporalMetricList = new ArrayList<TemporalMetric>();
    private List<NameSpace> nameSpaceList = new ArrayList<NameSpace>();
    private Map<String, Indexer> _index = this._fillIndex();

    public AbstractGraph(Graph graph) {
        this.graph = graph;
        this.graph.i18n().register("Sumus");
    }

    public AbstractGraph(Graph graph, AbstractGraph wrapper) {
        this.graph = graph;
        this.graph.i18n().register("Sumus");
        this.ticketList = new ArrayList<Ticket>(wrapper.ticketList);
        this.olapList = new ArrayList<Olap>(wrapper.olapList);
        this.filterList = new ArrayList<Filter>(wrapper.filterList);
        this.onClickInstantList = new ArrayList<OnClickInstant>(wrapper.onClickInstantList);
        this.palette = wrapper.palette;
        this.elementList = new ArrayList<Element>(wrapper.elementList);
        this.clusterList = new ArrayList<Cluster>(wrapper.clusterList);
        this.recordList = new ArrayList<Record>(wrapper.recordList);
        this.temporalRecordList = new ArrayList<TemporalRecord>(wrapper.temporalRecordList);
        this.entityList = new ArrayList<Entity>(wrapper.entityList);
        this.eventList = new ArrayList<Event>(wrapper.eventList);
        this.episodeList = new ArrayList<Episode>(wrapper.episodeList);
        this.reportList = new ArrayList<Report>(wrapper.reportList);
        this.cubeList = new ArrayList<Cube>(wrapper.cubeList);
        this.checkerList = new ArrayList<Checker>(wrapper.checkerList);
        this.geolocatedEntityList = new ArrayList<GeolocatedEntity>(wrapper.geolocatedEntityList);
        this.dynamicEntityList = new ArrayList<DynamicEntity>(wrapper.dynamicEntityList);
        this.aspectEntityList = new ArrayList<AspectEntity>(wrapper.aspectEntityList);
        this.abstractAccessList = new ArrayList<AbstractAccess>(wrapper.abstractAccessList);
        this.accessList = new ArrayList<Access>(wrapper.accessList);
        this.globalAccessList = new ArrayList<GlobalAccess>(wrapper.globalAccessList);
        this.categorizationList = new ArrayList<Categorization>(wrapper.categorizationList);
        this.abstractMetricList = new ArrayList<AbstractMetric>(wrapper.abstractMetricList);
        this.metricList = new ArrayList<Metric>(wrapper.metricList);
        this.temporalMetricList = new ArrayList<TemporalMetric>(wrapper.temporalMetricList);
        this.nameSpaceList = new ArrayList<NameSpace>(wrapper.nameSpaceList);
    }

    public <T extends GraphWrapper> T a$(Class<T> t) {
        return (T)this.core$().as(t);
    }

    public void update() {
        this._index.values().forEach(v -> v.clear());
        this.graph.rootList().forEach(r -> this.addNode$((Node)r));
    }

    protected void addNode$(Node node) {
        for (Concept c : node.conceptList()) {
            if (!this._index.containsKey(c.id())) continue;
            this._index.get(c.id()).add(node);
        }
        if (this._index.containsKey(node.id())) {
            this._index.get(node.id()).add(node);
        }
    }

    protected void removeNode$(Node node) {
        for (Concept c : node.conceptList()) {
            if (!this._index.containsKey(c.id())) continue;
            this._index.get(c.id()).remove(node);
        }
        if (this._index.containsKey(node.id())) {
            this._index.get(node.id()).remove(node);
        }
    }

    public URL resourceAsMessage$(String language, String key) {
        return this.graph.loadResource(this.graph.i18n().message(language, key, new Object[0]));
    }

    public List<Ticket> ticketList() {
        return this.ticketList;
    }

    public List<Olap> olapList() {
        return this.olapList;
    }

    public List<Filter> filterList() {
        return this.filterList;
    }

    public List<OnClickInstant> onClickInstantList() {
        return this.onClickInstantList;
    }

    public Palette palette() {
        return this.palette;
    }

    public List<Element> elementList() {
        return this.elementList;
    }

    public List<Cluster> clusterList() {
        return this.clusterList;
    }

    public List<Record> recordList() {
        return this.recordList;
    }

    public List<TemporalRecord> temporalRecordList() {
        return this.temporalRecordList;
    }

    public List<Entity> entityList() {
        return this.entityList;
    }

    public List<Event> eventList() {
        return this.eventList;
    }

    public List<Episode> episodeList() {
        return this.episodeList;
    }

    public List<Report> reportList() {
        return this.reportList;
    }

    public List<Cube> cubeList() {
        return this.cubeList;
    }

    public List<Checker> checkerList() {
        return this.checkerList;
    }

    public List<GeolocatedEntity> geolocatedEntityList() {
        return this.geolocatedEntityList;
    }

    public List<DynamicEntity> dynamicEntityList() {
        return this.dynamicEntityList;
    }

    public List<AspectEntity> aspectEntityList() {
        return this.aspectEntityList;
    }

    public List<AbstractAccess> abstractAccessList() {
        return this.abstractAccessList;
    }

    public List<Access> accessList() {
        return this.accessList;
    }

    public List<GlobalAccess> globalAccessList() {
        return this.globalAccessList;
    }

    public List<Categorization> categorizationList() {
        return this.categorizationList;
    }

    public List<AbstractMetric> abstractMetricList() {
        return this.abstractMetricList;
    }

    public List<Metric> metricList() {
        return this.metricList;
    }

    public List<TemporalMetric> temporalMetricList() {
        return this.temporalMetricList;
    }

    public List<NameSpace> nameSpaceList() {
        return this.nameSpaceList;
    }

    public Stream<Ticket> ticketList(Predicate<Ticket> filter) {
        return this.ticketList.stream().filter(filter);
    }

    public Ticket ticket(int index) {
        return this.ticketList.get(index);
    }

    public Stream<Olap> olapList(Predicate<Olap> filter) {
        return this.olapList.stream().filter(filter);
    }

    public Olap olap(int index) {
        return this.olapList.get(index);
    }

    public Stream<Filter> filterList(Predicate<Filter> filter) {
        return this.filterList.stream().filter(filter);
    }

    public Filter filter(int index) {
        return this.filterList.get(index);
    }

    public Stream<OnClickInstant> onClickInstantList(Predicate<OnClickInstant> filter) {
        return this.onClickInstantList.stream().filter(filter);
    }

    public OnClickInstant onClickInstant(int index) {
        return this.onClickInstantList.get(index);
    }

    public Stream<Element> elementList(Predicate<Element> filter) {
        return this.elementList.stream().filter(filter);
    }

    public Element element(int index) {
        return this.elementList.get(index);
    }

    public Stream<Cluster> clusterList(Predicate<Cluster> filter) {
        return this.clusterList.stream().filter(filter);
    }

    public Cluster cluster(int index) {
        return this.clusterList.get(index);
    }

    public Stream<Record> recordList(Predicate<Record> filter) {
        return this.recordList.stream().filter(filter);
    }

    public Record record(int index) {
        return this.recordList.get(index);
    }

    public Stream<TemporalRecord> temporalRecordList(Predicate<TemporalRecord> filter) {
        return this.temporalRecordList.stream().filter(filter);
    }

    public TemporalRecord temporalRecord(int index) {
        return this.temporalRecordList.get(index);
    }

    public Stream<Entity> entityList(Predicate<Entity> filter) {
        return this.entityList.stream().filter(filter);
    }

    public Entity entity(int index) {
        return this.entityList.get(index);
    }

    public Stream<Event> eventList(Predicate<Event> filter) {
        return this.eventList.stream().filter(filter);
    }

    public Event event(int index) {
        return this.eventList.get(index);
    }

    public Stream<Episode> episodeList(Predicate<Episode> filter) {
        return this.episodeList.stream().filter(filter);
    }

    public Episode episode(int index) {
        return this.episodeList.get(index);
    }

    public Stream<Report> reportList(Predicate<Report> filter) {
        return this.reportList.stream().filter(filter);
    }

    public Report report(int index) {
        return this.reportList.get(index);
    }

    public Stream<Cube> cubeList(Predicate<Cube> filter) {
        return this.cubeList.stream().filter(filter);
    }

    public Cube cube(int index) {
        return this.cubeList.get(index);
    }

    public Stream<Checker> checkerList(Predicate<Checker> filter) {
        return this.checkerList.stream().filter(filter);
    }

    public Checker checker(int index) {
        return this.checkerList.get(index);
    }

    public Stream<GeolocatedEntity> geolocatedEntityList(Predicate<GeolocatedEntity> filter) {
        return this.geolocatedEntityList.stream().filter(filter);
    }

    public GeolocatedEntity geolocatedEntity(int index) {
        return this.geolocatedEntityList.get(index);
    }

    public Stream<DynamicEntity> dynamicEntityList(Predicate<DynamicEntity> filter) {
        return this.dynamicEntityList.stream().filter(filter);
    }

    public DynamicEntity dynamicEntity(int index) {
        return this.dynamicEntityList.get(index);
    }

    public Stream<AspectEntity> aspectEntityList(Predicate<AspectEntity> filter) {
        return this.aspectEntityList.stream().filter(filter);
    }

    public AspectEntity aspectEntity(int index) {
        return this.aspectEntityList.get(index);
    }

    public Stream<AbstractAccess> abstractAccessList(Predicate<AbstractAccess> filter) {
        return this.abstractAccessList.stream().filter(filter);
    }

    public AbstractAccess abstractAccess(int index) {
        return this.abstractAccessList.get(index);
    }

    public Stream<Access> accessList(Predicate<Access> filter) {
        return this.accessList.stream().filter(filter);
    }

    public Access access(int index) {
        return this.accessList.get(index);
    }

    public Stream<GlobalAccess> globalAccessList(Predicate<GlobalAccess> filter) {
        return this.globalAccessList.stream().filter(filter);
    }

    public GlobalAccess globalAccess(int index) {
        return this.globalAccessList.get(index);
    }

    public Stream<Categorization> categorizationList(Predicate<Categorization> filter) {
        return this.categorizationList.stream().filter(filter);
    }

    public Categorization categorization(int index) {
        return this.categorizationList.get(index);
    }

    public Stream<AbstractMetric> abstractMetricList(Predicate<AbstractMetric> filter) {
        return this.abstractMetricList.stream().filter(filter);
    }

    public AbstractMetric abstractMetric(int index) {
        return this.abstractMetricList.get(index);
    }

    public Stream<Metric> metricList(Predicate<Metric> filter) {
        return this.metricList.stream().filter(filter);
    }

    public Metric metric(int index) {
        return this.metricList.get(index);
    }

    public Stream<TemporalMetric> temporalMetricList(Predicate<TemporalMetric> filter) {
        return this.temporalMetricList.stream().filter(filter);
    }

    public TemporalMetric temporalMetric(int index) {
        return this.temporalMetricList.get(index);
    }

    public Stream<NameSpace> nameSpaceList(Predicate<NameSpace> filter) {
        return this.nameSpaceList.stream().filter(filter);
    }

    public NameSpace nameSpace(int index) {
        return this.nameSpaceList.get(index);
    }

    public Graph core$() {
        return this.graph;
    }

    public I18n i18n$() {
        return this.graph.i18n();
    }

    public Create create() {
        return new Create("Misc", null);
    }

    public Create create(String stash) {
        return new Create(stash, null);
    }

    public Create create(String stash, String name) {
        return new Create(stash, name);
    }

    public Clear clear() {
        return new Clear();
    }

    private HashMap<String, Indexer> _fillIndex() {
        HashMap<String, Indexer> map = new HashMap<String, Indexer>();
        map.put("Ticket", new Indexer(node -> this.ticketList.add((Ticket)node.as(Ticket.class)), node -> this.ticketList.remove(node.as(Ticket.class)), () -> this.ticketList.clear()));
        map.put("Olap", new Indexer(node -> this.olapList.add((Olap)node.as(Olap.class)), node -> this.olapList.remove(node.as(Olap.class)), () -> this.olapList.clear()));
        map.put("Filter", new Indexer(node -> this.filterList.add((Filter)node.as(Filter.class)), node -> this.filterList.remove(node.as(Filter.class)), () -> this.filterList.clear()));
        map.put("OnClickInstant", new Indexer(node -> this.onClickInstantList.add((OnClickInstant)node.as(OnClickInstant.class)), node -> this.onClickInstantList.remove(node.as(OnClickInstant.class)), () -> this.onClickInstantList.clear()));
        map.put("Palette", new Indexer(node -> {
            this.palette = (Palette)node.as(Palette.class);
        }, node -> {
            this.palette = null;
        }, () -> {
            this.palette = null;
        }));
        map.put("Element", new Indexer(node -> this.elementList.add((Element)node.as(Element.class)), node -> this.elementList.remove(node.as(Element.class)), () -> this.elementList.clear()));
        map.put("Cluster", new Indexer(node -> this.clusterList.add((Cluster)node.as(Cluster.class)), node -> this.clusterList.remove(node.as(Cluster.class)), () -> this.clusterList.clear()));
        map.put("Record", new Indexer(node -> this.recordList.add((Record)node.as(Record.class)), node -> this.recordList.remove(node.as(Record.class)), () -> this.recordList.clear()));
        map.put("TemporalRecord", new Indexer(node -> this.temporalRecordList.add((TemporalRecord)node.as(TemporalRecord.class)), node -> this.temporalRecordList.remove(node.as(TemporalRecord.class)), () -> this.temporalRecordList.clear()));
        map.put("Entity", new Indexer(node -> this.entityList.add((Entity)node.as(Entity.class)), node -> this.entityList.remove(node.as(Entity.class)), () -> this.entityList.clear()));
        map.put("Event", new Indexer(node -> this.eventList.add((Event)node.as(Event.class)), node -> this.eventList.remove(node.as(Event.class)), () -> this.eventList.clear()));
        map.put("Episode", new Indexer(node -> this.episodeList.add((Episode)node.as(Episode.class)), node -> this.episodeList.remove(node.as(Episode.class)), () -> this.episodeList.clear()));
        map.put("Report", new Indexer(node -> this.reportList.add((Report)node.as(Report.class)), node -> this.reportList.remove(node.as(Report.class)), () -> this.reportList.clear()));
        map.put("Cube", new Indexer(node -> this.cubeList.add((Cube)node.as(Cube.class)), node -> this.cubeList.remove(node.as(Cube.class)), () -> this.cubeList.clear()));
        map.put("Checker", new Indexer(node -> this.checkerList.add((Checker)node.as(Checker.class)), node -> this.checkerList.remove(node.as(Checker.class)), () -> this.checkerList.clear()));
        map.put("Geolocated#Entity", new Indexer(node -> this.geolocatedEntityList.add((GeolocatedEntity)node.as(GeolocatedEntity.class)), node -> this.geolocatedEntityList.remove(node.as(GeolocatedEntity.class)), () -> this.geolocatedEntityList.clear()));
        map.put("Dynamic#Entity", new Indexer(node -> this.dynamicEntityList.add((DynamicEntity)node.as(DynamicEntity.class)), node -> this.dynamicEntityList.remove(node.as(DynamicEntity.class)), () -> this.dynamicEntityList.clear()));
        map.put("Aspect#Entity", new Indexer(node -> this.aspectEntityList.add((AspectEntity)node.as(AspectEntity.class)), node -> this.aspectEntityList.remove(node.as(AspectEntity.class)), () -> this.aspectEntityList.clear()));
        map.put("AbstractAccess", new Indexer(node -> this.abstractAccessList.add((AbstractAccess)node.as(AbstractAccess.class)), node -> this.abstractAccessList.remove(node.as(AbstractAccess.class)), () -> this.abstractAccessList.clear()));
        map.put("Access", new Indexer(node -> this.accessList.add((Access)node.as(Access.class)), node -> this.accessList.remove(node.as(Access.class)), () -> this.accessList.clear()));
        map.put("GlobalAccess", new Indexer(node -> this.globalAccessList.add((GlobalAccess)node.as(GlobalAccess.class)), node -> this.globalAccessList.remove(node.as(GlobalAccess.class)), () -> this.globalAccessList.clear()));
        map.put("Categorization", new Indexer(node -> this.categorizationList.add((Categorization)node.as(Categorization.class)), node -> this.categorizationList.remove(node.as(Categorization.class)), () -> this.categorizationList.clear()));
        map.put("AbstractMetric", new Indexer(node -> this.abstractMetricList.add((AbstractMetric)node.as(AbstractMetric.class)), node -> this.abstractMetricList.remove(node.as(AbstractMetric.class)), () -> this.abstractMetricList.clear()));
        map.put("Metric", new Indexer(node -> this.metricList.add((Metric)node.as(Metric.class)), node -> this.metricList.remove(node.as(Metric.class)), () -> this.metricList.clear()));
        map.put("TemporalMetric", new Indexer(node -> this.temporalMetricList.add((TemporalMetric)node.as(TemporalMetric.class)), node -> this.temporalMetricList.remove(node.as(TemporalMetric.class)), () -> this.temporalMetricList.clear()));
        map.put("NameSpace", new Indexer(node -> this.nameSpaceList.add((NameSpace)node.as(NameSpace.class)), node -> this.nameSpaceList.remove(node.as(NameSpace.class)), () -> this.nameSpaceList.clear()));
        return map;
    }

    static interface IndexClear {
        public void clear();
    }

    static interface Remove {
        public void remove(Node var1);
    }

    static interface Add {
        public void add(Node var1);
    }

    public static class Indexer {
        Add add;
        Remove remove;
        IndexClear clear;

        public Indexer(Add add, Remove remove, IndexClear clear) {
            this.add = add;
            this.remove = remove;
            this.clear = clear;
        }

        void add(Node node) {
            this.add.add(node);
        }

        void remove(Node node) {
            this.remove.remove(node);
        }

        void clear() {
            this.clear.clear();
        }
    }

    public class Clear {
        public void ticket(Predicate<Ticket> filter) {
            new ArrayList<Ticket>(AbstractGraph.this.ticketList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void olap(Predicate<Olap> filter) {
            new ArrayList<Olap>(AbstractGraph.this.olapList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void filter(Predicate<Filter> filter) {
            new ArrayList<Filter>(AbstractGraph.this.filterList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void onClickInstant(Predicate<OnClickInstant> filter) {
            new ArrayList<OnClickInstant>(AbstractGraph.this.onClickInstantList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void cluster(Predicate<Cluster> filter) {
            new ArrayList<Cluster>(AbstractGraph.this.clusterList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void cube(Predicate<Cube> filter) {
            new ArrayList<Cube>(AbstractGraph.this.cubeList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void checker(Predicate<Checker> filter) {
            new ArrayList<Checker>(AbstractGraph.this.checkerList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void access(Predicate<Access> filter) {
            new ArrayList<Access>(AbstractGraph.this.accessList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void globalAccess(Predicate<GlobalAccess> filter) {
            new ArrayList<GlobalAccess>(AbstractGraph.this.globalAccessList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void categorization(Predicate<Categorization> filter) {
            new ArrayList<Categorization>(AbstractGraph.this.categorizationList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void metric(Predicate<Metric> filter) {
            new ArrayList<Metric>(AbstractGraph.this.metricList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void temporalMetric(Predicate<TemporalMetric> filter) {
            new ArrayList<TemporalMetric>(AbstractGraph.this.temporalMetricList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void nameSpace(Predicate<NameSpace> filter) {
            new ArrayList<NameSpace>(AbstractGraph.this.nameSpaceList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        private final String stash;
        private final String name;

        public Create(String stash, String name) {
            this.stash = stash;
            this.name = name;
        }

        public Ticket ticket(String label, String shortLabel, List<Concept> events) {
            Ticket newElement = (Ticket)((Ticket)AbstractGraph.this.graph.createRoot(Ticket.class, this.stash, this.name)).a$(Ticket.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "shortLabel", Collections.singletonList(shortLabel));
            newElement.core$().set((Layer)newElement, "events", events);
            return newElement;
        }

        public Olap olap(String label, NameSpacesLoader nameSpaces, List<Ticket> tickets) {
            Olap newElement = (Olap)((Olap)AbstractGraph.this.graph.createRoot(Olap.class, this.stash, this.name)).a$(Olap.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "nameSpaces", Collections.singletonList(nameSpaces));
            newElement.core$().set((Layer)newElement, "tickets", tickets);
            return newElement;
        }

        public Filter filter(String label, String username) {
            Filter newElement = (Filter)((Filter)AbstractGraph.this.graph.createRoot(Filter.class, this.stash, this.name)).a$(Filter.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "username", Collections.singletonList(username));
            return newElement;
        }

        public OnClickInstant onClickInstant(CatalogList catalogs) {
            OnClickInstant newElement = (OnClickInstant)((OnClickInstant)AbstractGraph.this.graph.createRoot(OnClickInstant.class, this.stash, this.name)).a$(OnClickInstant.class);
            newElement.core$().set((Layer)newElement, "catalogs", Collections.singletonList(catalogs));
            return newElement;
        }

        public Palette palette() {
            Palette newElement = (Palette)((Palette)AbstractGraph.this.graph.createRoot(Palette.class, this.stash, this.name)).a$(Palette.class);
            return newElement;
        }

        public Cluster cluster(Catalog catalog, String label, String username) {
            Cluster newElement = (Cluster)((Cluster)AbstractGraph.this.graph.createRoot(Cluster.class, this.stash, this.name)).a$(Cluster.class);
            newElement.core$().set((Layer)newElement, "catalog", Collections.singletonList(catalog));
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "username", Collections.singletonList(username));
            return newElement;
        }

        public Cube cube() {
            Cube newElement = (Cube)((Cube)AbstractGraph.this.graph.createRoot(Cube.class, this.stash, this.name)).a$(Cube.class);
            return newElement;
        }

        public Checker checker(Concept record) {
            Checker newElement = (Checker)((Checker)AbstractGraph.this.graph.createRoot(Checker.class, this.stash, this.name)).a$(Checker.class);
            newElement.core$().set((Layer)newElement, "record", Collections.singletonList(record));
            return newElement;
        }

        public Access access(List<NameSpace> namespaces) {
            Access newElement = (Access)((Access)AbstractGraph.this.graph.createRoot(Access.class, this.stash, this.name)).a$(Access.class);
            newElement.core$().set((Layer)newElement, "namespaces", namespaces);
            return newElement;
        }

        public GlobalAccess globalAccess() {
            GlobalAccess newElement = (GlobalAccess)((GlobalAccess)AbstractGraph.this.graph.createRoot(GlobalAccess.class, this.stash, this.name)).a$(GlobalAccess.class);
            return newElement;
        }

        public Categorization categorization(String label, Expression<List<String>> tags) {
            Categorization newElement = (Categorization)((Categorization)AbstractGraph.this.graph.createRoot(Categorization.class, this.stash, this.name)).a$(Categorization.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            newElement.core$().set((Layer)newElement, "tags", Collections.singletonList(tags));
            return newElement;
        }

        public Metric metric() {
            Metric newElement = (Metric)((Metric)AbstractGraph.this.graph.createRoot(Metric.class, this.stash, this.name)).a$(Metric.class);
            return newElement;
        }

        public TemporalMetric temporalMetric() {
            TemporalMetric newElement = (TemporalMetric)((TemporalMetric)AbstractGraph.this.graph.createRoot(TemporalMetric.class, this.stash, this.name)).a$(TemporalMetric.class);
            return newElement;
        }

        public NameSpace nameSpace(String label) {
            NameSpace newElement = (NameSpace)((NameSpace)AbstractGraph.this.graph.createRoot(NameSpace.class, this.stash, this.name)).a$(NameSpace.class);
            newElement.core$().set((Layer)newElement, "label", Collections.singletonList(label));
            return newElement;
        }
    }
}

