/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays.builders;

import io.intino.sumus.analytics.Scaler;
import io.intino.sumus.analytics.viewmodels.Histogram;
import io.intino.sumus.analytics.viewmodels.TagView;
import io.intino.sumus.box.displays.builders.DecimalPlacesBuilder;
import io.intino.sumus.box.displays.builders.TagViewBuilder;
import io.intino.sumus.box.schemas.Indicator;
import io.intino.sumus.box.schemas.Ticket;
import io.intino.sumus.graph.AbstractMetric;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class HistogramBuilder {
    public static io.intino.sumus.box.schemas.Histogram build(Histogram histogram) {
        HashMap scalerMap = new HashMap();
        List<String> tags = histogram.tags();
        return new io.intino.sumus.box.schemas.Histogram().tagViewList(TagViewBuilder.buildList(tags.stream().map(TagView::new).collect(Collectors.toList()))).ticketList(histogram.tickets().stream().map(t -> HistogramBuilder.ticket(t, tags, scalerMap)).collect(Collectors.toList()));
    }

    private static Ticket ticket(Histogram.HistogramTicket ticket, List<String> tags, Map<String, Scaler> scalerMap) {
        Scaler scaler = HistogramBuilder.scaler(ticket, scalerMap);
        return new Ticket().name(ticket.name()).label(ticket.label()).shortLabel(ticket.shortLabel()).values(HistogramBuilder.scaleValues(ticket.values(), scaler)).indicatorList(HistogramBuilder.indicators(ticket, tags, scalerMap)).unit(scaler.unitLabel());
    }

    private static List<Indicator> indicators(Histogram.HistogramTicket ticket, List<String> tags, Map<String, Scaler> scalerMap) {
        Scaler scaler = HistogramBuilder.scaler(ticket, scalerMap);
        return ticket.indicators().stream().map(i -> HistogramBuilder.indicator(i, scaler, tags)).collect(Collectors.toList());
    }

    private static Indicator indicator(Histogram.HistogramIndicator indicator, Scaler scaler, List<String> tags) {
        return new Indicator().label(indicator.label()).minValue(indicator.minValue()).maxValue(indicator.maxValue()).values(HistogramBuilder.scaleValues(indicator.values(), scaler)).color(indicator.color()).decimalPlaces(DecimalPlacesBuilder.build(indicator.decimalPlaces()));
    }

    private static Scaler scaler(Histogram.HistogramTicket ticket, Map<String, Scaler> scalerMap) {
        if (!scalerMap.containsKey(ticket.name())) {
            List<Histogram.HistogramIndicator> indicators = ticket.indicators();
            double max = ticket.maxValue();
            AbstractMetric metric = (AbstractMetric)indicators.get(0).unit().core$().ownerAs(AbstractMetric.class);
            Scaler scaler = metric.scaler().scaler(max, indicators.get(0).unit());
            scalerMap.put(ticket.name(), scaler);
        }
        return scalerMap.get(ticket.name());
    }

    private static List<Double> scaleValues(List<Double> values, Scaler scaler) {
        return values.stream().map(e -> {
            e = scaler.scale((double)e);
            return e;
        }).collect(Collectors.toList());
    }
}

