/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.sumus.analytics.categorization.TemporalCategorization;
import io.intino.sumus.analytics.viewmodels.FilterCondition;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.SumusCategorization;
import io.intino.sumus.box.displays.SumusCategorizationContainer;
import io.intino.sumus.box.displays.builders.FilterBuilder;
import io.intino.sumus.box.displays.builders.ReferenceBuilder;
import io.intino.sumus.box.displays.notifiers.SumusFilterNotifier;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Filter;
import io.intino.tara.magritte.Layer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class SumusFilter
extends SumusCategorizationContainer<SumusFilterNotifier> {
    private Filter filter;
    private final List<Consumer<Filter>> applyListeners = new ArrayList<Consumer<Filter>>();
    private final List<Consumer<Filter>> quitListeners = new ArrayList<Consumer<Filter>>();
    private final List<Consumer<Filter>> changeListeners = new ArrayList<Consumer<Filter>>();
    private final List<Consumer<Filter>> removeListeners = new ArrayList<Consumer<Filter>>();
    private boolean refreshing = false;

    public SumusFilter(SumusBox box) {
        super(box);
    }

    public void filter(Filter filter) {
        this.filter = filter;
    }

    public void apply() {
        this.applyListeners.forEach(l -> l.accept(this.filter));
    }

    public void onApply(Consumer<Filter> consumer) {
        this.applyListeners.add(consumer);
    }

    public void quit() {
        this.quitListeners.forEach(l -> l.accept(this.filter));
    }

    public void onQuit(Consumer<Filter> consumer) {
        this.quitListeners.add(consumer);
    }

    public void remove() {
        this.filter.core$().delete();
        this.removeListeners.forEach(l -> l.accept(this.filter));
    }

    public void onRemove(Consumer<Filter> consumer) {
        this.removeListeners.add(consumer);
    }

    public void onChange(Consumer<Filter> consumer) {
        this.changeListeners.add(consumer);
    }

    public List<FilterCondition> conditions() {
        return this.children(SumusCategorization.class).stream().filter(this::isFilteringByCategorization).filter(SumusCategorization::hasFilterCondition).map(SumusCategorization::asFilterCondition).collect(Collectors.toList());
    }

    public void clear() {
        this.filter.categorizationList().clear();
        this.categorizationDisplays().forEach(SumusCategorization::selectNone);
        this.sendRefreshFilter();
    }

    @Override
    protected void init() {
        this.sendRefreshFilter();
        super.init();
    }

    @Override
    protected void sendRefreshCategorizationList(List<Categorization> categorizationList) {
        ((SumusFilterNotifier)this.notifier).refreshCategorizationList(ReferenceBuilder.buildList(categorizationList));
    }

    @Override
    protected void sendRefreshTemporalCategorizationList(List<TemporalCategorization> categorizationList) {
        categorizationList.forEach(c -> {
            SumusCategorization display = this.categorizationDisplay(c.name$());
            if (display == null) {
                return;
            }
            display.categorization((Categorization)((Object)c));
            display.refresh();
        });
        ((SumusFilterNotifier)this.notifier).refreshTemporalCategorizationList(ReferenceBuilder.buildList(categorizationList));
    }

    public void refresh() {
        super.refresh();
        try {
            this.refreshing = true;
            this.sendRefreshFilter();
            this.refreshCategorizationSelection();
        }
        finally {
            this.refreshing = false;
        }
    }

    public void allowTemporalCategorizations(boolean value) {
        if (value) {
            ((SumusFilterNotifier)this.notifier).showTemporalCategorizations();
        } else {
            ((SumusFilterNotifier)this.notifier).hideTemporalCategorizations();
        }
    }

    public void addCategorization(String name) {
        SumusCategorization categorizationDisplay = this.categorizationDisplay(name);
        categorizationDisplay.selectAll();
    }

    public void removeCategorization(String name) {
        this.filter.categorizationList().stream().filter((? super T c) -> c.name$().equals(name)).findFirst().ifPresent(Layer::delete$);
        this.filter.save$();
        this.sendRefreshFilter();
        this.changeListeners.parallelStream().forEach(c -> c.accept(this.filter));
    }

    @Override
    protected void addListeners(SumusCategorization categorizationDisplay) {
        String categorization = categorizationDisplay.categorization().name$();
        categorizationDisplay.onSelect(tags -> this.notifyFilterChange(categorization, (List<String>)tags));
    }

    private void notifyFilterChange(String categorizationName, List<String> tags) {
        if (this.filter == null) {
            return;
        }
        Optional<Filter.Categorization> optionalCategorization = this.findCategorization(categorizationName);
        Filter.Categorization categorization = optionalCategorization.orElseGet(() -> this.filter.create(categorizationName).categorization(categorizationName));
        categorization.tags().clear();
        tags.forEach(c -> categorization.tags().add((String)c));
        this.filter.save$();
        if (!this.refreshing) {
            this.changeListeners.parallelStream().forEach(c -> c.accept(this.filter));
        }
    }

    private void sendRefreshFilter() {
        ((SumusFilterNotifier)this.notifier).refreshFilter(this.filter != null ? FilterBuilder.build(this.filter) : null);
    }

    private void refreshCategorizationSelection() {
        this.children(SumusCategorization.class).parallelStream().forEach(display -> {
            List<Object> tags;
            Filter.Categorization categorization = this.filter != null ? (Filter.Categorization)this.findCategorization(display.categorization().name$()).orElse(null) : null;
            List<Object> list = tags = categorization != null ? categorization.tags() : Collections.emptyList();
            if (tags.size() > 0) {
                display.select(new ArrayList<Object>(tags));
            } else {
                display.selectNone();
            }
        });
    }

    private Optional<Filter.Categorization> findCategorization(String name) {
        return this.filter.categorizationList().stream().filter((? super T c) -> c.name$().equals(name)).findFirst();
    }

    private boolean isFilteringByCategorization(SumusCategorization display) {
        Categorization categorization = display.categorization();
        return this.filter.categorizationList().stream().filter((? super T c) -> c.name$().equals(categorization.name$())).count() > 0L;
    }
}

