/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.alexandria.ui.displays.AlexandriaDisplay;
import io.intino.alexandria.ui.displays.AlexandriaDisplayNotifier;
import io.intino.alexandria.ui.displays.AlexandriaNavigator;
import io.intino.alexandria.ui.helpers.TimeScaleHandler;
import io.intino.sumus.analytics.categorization.TemporalCategorization;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.rules.Chart;
import io.intino.sumus.helpers.ChartSpec;
import io.intino.sumus.helpers.ChartSpecHandler;
import java.util.ArrayList;
import java.util.List;

public abstract class SumusChartDialog<DN extends AlexandriaDisplayNotifier, N extends AlexandriaNavigator>
extends SumusDisplay<DN> {
    private final N navigatorDisplay;
    private final Chart type;
    private TimeScaleHandler timeScaleHandler;
    private ChartSpecHandler chartSpecHandler;
    private ChartSpec spec = null;

    public SumusChartDialog(SumusBox box, Chart type, N navigatorDisplay) {
        super(box);
        this.navigatorDisplay = navigatorDisplay;
        this.type = type;
    }

    public Chart type() {
        return this.type;
    }

    public void selectTickets(String[] tickets) {
        this.chartSpecHandler.selectTickets(tickets);
        this.chartSpecHandler.update();
    }

    protected void init() {
        super.init();
        this.configureNavigatorDisplay();
    }

    protected void configureNavigatorDisplay() {
        this.navigatorDisplay.timeScaleHandler(this.timeScaleHandler());
        this.addNavigatorListeners(this.navigatorDisplay);
        this.addAndPersonify((AlexandriaDisplay)this.navigatorDisplay);
    }

    protected TimeScaleHandler timeScaleHandler() {
        return this.timeScaleHandler;
    }

    public void timeScaleHandler(TimeScaleHandler timeScaleHandler) {
        this.timeScaleHandler = timeScaleHandler;
    }

    protected ChartSpecHandler chartSpecHandler() {
        return this.chartSpecHandler;
    }

    public void chartSpecHandler(ChartSpecHandler chartSpecHandler) {
        this.chartSpecHandler = chartSpecHandler;
        this.chartSpecHandler.onChange(this::specification);
    }

    protected List<Categorization> categorizations() {
        return this.chartSpecHandler.olapCategorizations();
    }

    protected List<TemporalCategorization> temporalCategorizations() {
        return this.chartSpecHandler.olapTemporalCategorizations();
    }

    protected ChartSpec specification() {
        return this.chartSpecHandler.specification();
    }

    public void specification(ChartSpec spec) {
        this.spec = spec;
        this.update();
    }

    protected void update() {
        this.sendTickets();
        this.sendCategorizations();
    }

    protected abstract void sendTickets();

    protected abstract void sendCategorizations();

    public abstract void addNavigatorListeners(N var1);

    protected Categorization categorizationOf(String key) {
        return this.allCategorizations().stream().filter(c -> c.name$().equals(key) || c.label().equals(key)).findFirst().orElse(null);
    }

    protected List<Categorization> allCategorizations() {
        ArrayList<Categorization> result = new ArrayList<Categorization>();
        result.addAll(this.categorizations());
        result.addAll(this.temporalCategorizations());
        return result;
    }
}

