/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box.displays;

import io.intino.alexandria.ui.displays.AlexandriaDisplay;
import io.intino.alexandria.ui.helpers.TimeScaleHandler;
import io.intino.sumus.analytics.categorization.TemporalCategorization;
import io.intino.sumus.analytics.viewmodels.Drill;
import io.intino.sumus.analytics.viewmodels.FilterCondition;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.displays.SumusCategorizationComparator;
import io.intino.sumus.box.displays.SumusDisplay;
import io.intino.sumus.box.displays.SumusFilter;
import io.intino.sumus.box.displays.SumusFilterList;
import io.intino.sumus.box.displays.SumusTimeChartDesign;
import io.intino.sumus.box.displays.notifiers.SumusAnalyzeNotifier;
import io.intino.sumus.graph.Filter;
import io.intino.sumus.graph.rules.Chart;
import io.intino.sumus.helpers.ChartSpecHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class SumusAnalyze
extends SumusDisplay<SumusAnalyzeNotifier> {
    private TimeScaleHandler timeScaleHandler;
    private ChartSpecHandler chartSpecHandler;
    private List<Consumer<List<FilterCondition>>> filterChangeListeners = new ArrayList<Consumer<List<FilterCondition>>>();
    private List<BiConsumer<List<Drill>, Boolean>> drillChangeListeners = new ArrayList<BiConsumer<List<Drill>, Boolean>>();
    private Map<Filter, List<FilterCondition>> conditionsMap = new HashMap<Filter, List<FilterCondition>>();
    private SumusFilter currentFilterDisplay = null;

    public SumusAnalyze(SumusBox box) {
        super(box);
    }

    public void timeScaleHandler(TimeScaleHandler timeScaleHandler) {
        this.timeScaleHandler = timeScaleHandler;
    }

    public void chartSpecHandler(ChartSpecHandler chartSpecHandler) {
        this.chartSpecHandler = chartSpecHandler;
    }

    public void onFilter(Consumer<List<FilterCondition>> consumer) {
        this.filterChangeListeners.add(consumer);
    }

    public void onDrill(BiConsumer<List<Drill>, Boolean> consumer) {
        this.drillChangeListeners.add(consumer);
    }

    public void allowTemporalCategorizations(boolean value) {
        ((SumusFilter)this.child(SumusFilter.class)).allowTemporalCategorizations(value);
    }

    public void selectChart(Chart chart) {
        ((SumusTimeChartDesign)this.child(SumusTimeChartDesign.class)).selectChart(chart);
    }

    public void updateTemporalCategorizations(List<TemporalCategorization> availableCategorizations) {
        ((SumusTimeChartDesign)this.child(SumusTimeChartDesign.class)).updateTemporalCategorizations(availableCategorizations);
    }

    protected void init() {
        super.init();
        this.createTimeChartDesignDisplay();
        this.createCategorizationComparatorDisplay();
        this.createFilterListDisplay();
        this.createFilterDisplay();
        this.refreshVisibility();
    }

    private void createTimeChartDesignDisplay() {
        SumusTimeChartDesign display = new SumusTimeChartDesign((SumusBox)this.box);
        display.timeScaleHandler(this.timeScaleHandler);
        display.chartSpecHandler(this.chartSpecHandler);
        this.addAndPersonify((AlexandriaDisplay)display);
    }

    private void createCategorizationComparatorDisplay() {
        SumusCategorizationComparator display = new SumusCategorizationComparator((SumusBox)this.box);
        display.categorizations(this.chartSpecHandler.olapCategorizations());
        display.onApply(this::applyDrill);
        display.onQuit(this::quitDrill);
        this.addAndPersonify((AlexandriaDisplay)display);
    }

    private void createFilterListDisplay() {
        SumusFilterList display = new SumusFilterList((SumusBox)this.box);
        display.onSelect(this::refreshCurrentFilter);
        display.onApply(this::applyFilter);
        display.onQuit(this::quitFilter);
        display.onRemoveFilter(this::removeFilter);
        this.addAndPersonify((AlexandriaDisplay)display);
    }

    private void createFilterDisplay() {
        this.currentFilterDisplay = new SumusFilter((SumusBox)this.box);
        this.currentFilterDisplay.categorizations(this.chartSpecHandler.olapCategorizations());
        this.currentFilterDisplay.onApply(this::applyFilter);
        this.currentFilterDisplay.onChange(this::updateFilter);
        this.currentFilterDisplay.onQuit(this::quitFilter);
        this.currentFilterDisplay.onRemove(this::removeFilter);
        this.addAndPersonify((AlexandriaDisplay)this.currentFilterDisplay);
    }

    private void refreshCurrentFilter(Filter filter) {
        if (this.currentFilterDisplay == null) {
            return;
        }
        this.currentFilterDisplay.filter(filter);
        this.currentFilterDisplay.refresh();
    }

    private void applyFilter(Filter filter) {
        this.conditionsMap.put(filter, this.currentFilterDisplay.conditions());
        this.notifyConditionsChange();
    }

    private void updateFilter(Filter filter) {
        if (!this.conditionsMap.containsKey((Object)filter)) {
            return;
        }
        this.conditionsMap.put(filter, this.currentFilterDisplay.conditions());
        this.notifyConditionsChange();
    }

    public void quitFilter(String filter) {
        ((SumusFilterList)this.child(SumusFilterList.class)).quitFilter(filter);
    }

    public void removeFilter(Filter filter) {
        this.quitFilter(filter);
        SumusFilterList display = (SumusFilterList)this.child(SumusFilterList.class);
        display.refresh();
        List<Filter> filters = display.filterList();
        this.refreshCurrentFilter(filters.size() == 1 ? filters.get(0) : null);
    }

    public void quitFilter(Filter filter) {
        this.conditionsMap.remove((Object)filter);
        this.notifyConditionsChange();
    }

    public void quitFilters() {
        this.conditionsMap.clear();
        this.notifyConditionsChange();
    }

    public List<Filter> filterList() {
        return this.conditionsMap.keySet().stream().collect(Collectors.toList());
    }

    public void enableComparePanel() {
        ((SumusAnalyzeNotifier)this.notifier).enableComparePanel();
    }

    public void disableComparePanel() {
        ((SumusAnalyzeNotifier)this.notifier).disableComparePanel();
    }

    private void applyDrill(Drill drill, boolean includeGlobalSerie) {
        this.notifyDrillChange(drill, includeGlobalSerie);
    }

    private void quitDrill(Drill drill) {
        this.notifyDrillChange(null, false);
    }

    private void refreshVisibility() {
        ((SumusAnalyzeNotifier)this.notifier).refreshVisibility(!this.isEmpty());
    }

    private boolean isEmpty() {
        if (this.chartSpecHandler.olapTickets().isEmpty()) {
            return true;
        }
        return this.chartSpecHandler.olapCategorizations().isEmpty() && this.chartSpecHandler.olapTemporalCategorizations().isEmpty();
    }

    private List<FilterCondition> conditions() {
        return this.conditionsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void notifyConditionsChange() {
        this.filterChangeListeners.forEach(l -> l.accept(this.conditions()));
    }

    private void notifyDrillChange(final Drill drill, boolean includeGlobalSerie) {
        this.drillChangeListeners.forEach(l -> l.accept(drill != null ? new ArrayList<Drill>(){
            {
                this.add(drill);
            }
        } : Collections.emptyList(), includeGlobalSerie));
    }
}

