/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.ui.displays.AlexandriaAbstractCatalog;
import io.intino.alexandria.ui.displays.Soul;
import io.intino.alexandria.ui.model.Catalog;
import io.intino.alexandria.ui.model.Item;
import io.intino.alexandria.ui.model.catalog.arrangement.Grouping;
import io.intino.alexandria.ui.services.AuthService;
import io.intino.alexandria.ui.services.EditorService;
import io.intino.sumus.Settings;
import io.intino.sumus.box.AbstractBox;
import io.intino.sumus.box.SumusConfiguration;
import io.intino.sumus.graph.SumusGraph;
import io.intino.sumus.helpers.TranslatorHelper;
import io.intino.tara.magritte.Graph;
import java.net.URL;
import java.util.Collection;

public class SumusBox
extends AbstractBox {
    private SumusGraph sumusGraph;
    private Settings settings;
    private TranslatorHelper translatorHelper;

    public SumusBox(String[] args) {
        super(args);
    }

    public SumusBox(SumusConfiguration configuration) {
        super(configuration);
        this.settings = new Settings(configuration.args());
    }

    @Override
    public Box put(Object o) {
        if (o instanceof Graph) {
            this.sumusGraph = (SumusGraph)((Graph)o).as(SumusGraph.class);
        }
        if (o instanceof TranslatorHelper) {
            this.translatorHelper = (TranslatorHelper)o;
        }
        return this;
    }

    @Override
    public Box open() {
        this.translatorHelper = new TranslatorHelper(this.sumusGraph);
        super.open();
        this.graph().init();
        return this;
    }

    public SumusGraph graph() {
        return this.sumusGraph;
    }

    public Settings actionsConfiguration() {
        return this.settings;
    }

    @Override
    public void close() {
        super.close();
    }

    @Override
    protected AuthService authService(URL authServiceUrl) {
        return null;
    }

    @Override
    protected EditorService editorService(URL editorServiceUrl) {
        return null;
    }

    public TranslatorHelper translatorHelper() {
        return this.translatorHelper;
    }

    public void refreshDisplaysOf(Catalog catalog, Grouping grouping) {
        this.uiSouls.values().stream().map(Soul::getAll).flatMap(Collection::stream).filter(d -> d instanceof AlexandriaAbstractCatalog && ((AlexandriaAbstractCatalog)d).isFor(catalog)).forEach(d -> ((AlexandriaAbstractCatalog)d).refresh(grouping));
    }

    public void refreshDisplaysOf(Catalog catalog, boolean categorizationsHaveChanges, Item ... items) {
        this.uiSouls.values().stream().map(Soul::getAll).flatMap(Collection::stream).filter(d -> d instanceof AlexandriaAbstractCatalog && ((AlexandriaAbstractCatalog)d).isFor(catalog)).forEach(d -> {
            AlexandriaAbstractCatalog display = (AlexandriaAbstractCatalog)d;
            display.dirty(true);
            if (categorizationsHaveChanges || items.length == 0) {
                display.refresh();
            } else {
                display.refresh(items);
            }
        });
    }
}

