/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.box;

import io.intino.alexandria.core.Box;
import io.intino.alexandria.rest.spark.PushService;
import io.intino.alexandria.ui.AssetResourceLoader;
import io.intino.alexandria.ui.UI;
import io.intino.alexandria.ui.UIAlexandriaSpark;
import io.intino.alexandria.ui.spark.UIRouter;
import io.intino.alexandria.ui.spark.UISparkManager;
import io.intino.alexandria.ui.spark.resources.AfterDisplayRequest;
import io.intino.alexandria.ui.spark.resources.AssetResource;
import io.intino.alexandria.ui.spark.resources.AuthenticateCallbackResource;
import io.intino.alexandria.ui.spark.resources.BeforeDisplayRequest;
import io.intino.sumus.box.SumusBox;
import io.intino.sumus.box.SumusConfiguration;
import io.intino.sumus.box.displays.SumusAnalyze;
import io.intino.sumus.box.displays.SumusCategorization;
import io.intino.sumus.box.displays.SumusCategorizationComparator;
import io.intino.sumus.box.displays.SumusDesktop;
import io.intino.sumus.box.displays.SumusError;
import io.intino.sumus.box.displays.SumusFilter;
import io.intino.sumus.box.displays.SumusFilterList;
import io.intino.sumus.box.displays.SumusNameSpace;
import io.intino.sumus.box.displays.SumusOlap;
import io.intino.sumus.box.displays.SumusTimeBarChart;
import io.intino.sumus.box.displays.SumusTimeBarChartDialog;
import io.intino.sumus.box.displays.SumusTimeChartDesign;
import io.intino.sumus.box.displays.SumusTimeCrossTable;
import io.intino.sumus.box.displays.SumusTimeCrossTableDialog;
import io.intino.sumus.box.displays.SumusTimeScatterChart;
import io.intino.sumus.box.displays.SumusTimeScatterChartDialog;
import io.intino.sumus.box.displays.SumusTimeSeriesChart;
import io.intino.sumus.box.displays.SumusTimeSeriesChartDialog;
import io.intino.sumus.box.displays.notifiers.SumusAnalyzeNotifier;
import io.intino.sumus.box.displays.notifiers.SumusCategorizationComparatorNotifier;
import io.intino.sumus.box.displays.notifiers.SumusCategorizationNotifier;
import io.intino.sumus.box.displays.notifiers.SumusDesktopNotifier;
import io.intino.sumus.box.displays.notifiers.SumusErrorNotifier;
import io.intino.sumus.box.displays.notifiers.SumusFilterListNotifier;
import io.intino.sumus.box.displays.notifiers.SumusFilterNotifier;
import io.intino.sumus.box.displays.notifiers.SumusNameSpaceNotifier;
import io.intino.sumus.box.displays.notifiers.SumusOlapNotifier;
import io.intino.sumus.box.displays.notifiers.SumusTimeBarChartDialogNotifier;
import io.intino.sumus.box.displays.notifiers.SumusTimeBarChartNotifier;
import io.intino.sumus.box.displays.notifiers.SumusTimeChartDesignNotifier;
import io.intino.sumus.box.displays.notifiers.SumusTimeCrossTableDialogNotifier;
import io.intino.sumus.box.displays.notifiers.SumusTimeCrossTableNotifier;
import io.intino.sumus.box.displays.notifiers.SumusTimeScatterChartDialogNotifier;
import io.intino.sumus.box.displays.notifiers.SumusTimeScatterChartNotifier;
import io.intino.sumus.box.displays.notifiers.SumusTimeSeriesChartDialogNotifier;
import io.intino.sumus.box.displays.notifiers.SumusTimeSeriesChartNotifier;
import io.intino.sumus.box.displays.requesters.SumusAnalyzeRequester;
import io.intino.sumus.box.displays.requesters.SumusCategorizationComparatorRequester;
import io.intino.sumus.box.displays.requesters.SumusCategorizationRequester;
import io.intino.sumus.box.displays.requesters.SumusDesktopRequester;
import io.intino.sumus.box.displays.requesters.SumusErrorRequester;
import io.intino.sumus.box.displays.requesters.SumusFilterListRequester;
import io.intino.sumus.box.displays.requesters.SumusFilterRequester;
import io.intino.sumus.box.displays.requesters.SumusNameSpaceRequester;
import io.intino.sumus.box.displays.requesters.SumusOlapRequester;
import io.intino.sumus.box.displays.requesters.SumusTimeBarChartDialogRequester;
import io.intino.sumus.box.displays.requesters.SumusTimeBarChartRequester;
import io.intino.sumus.box.displays.requesters.SumusTimeChartDesignRequester;
import io.intino.sumus.box.displays.requesters.SumusTimeCrossTableDialogRequester;
import io.intino.sumus.box.displays.requesters.SumusTimeCrossTableRequester;
import io.intino.sumus.box.displays.requesters.SumusTimeScatterChartDialogRequester;
import io.intino.sumus.box.displays.requesters.SumusTimeScatterChartRequester;
import io.intino.sumus.box.displays.requesters.SumusTimeSeriesChartDialogRequester;
import io.intino.sumus.box.displays.requesters.SumusTimeSeriesChartRequester;
import io.intino.sumus.box.resources.AnalyticsPageResource;

public class PlatformUiService
extends UI {
    public static void init(UIAlexandriaSpark spark, SumusBox box) {
        SumusConfiguration configuration = box.configuration();
        ((UIRouter)spark.route("/push")).push((PushService)new io.intino.alexandria.ui.services.push.PushService());
        ((UIRouter)spark.route("/authenticate-callback")).get(manager -> new AuthenticateCallbackResource(manager, PlatformUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/asset/:name")).get(manager -> new AssetResource(name -> new AssetResourceLoader((Box)box).load(name), manager, PlatformUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/analytics")).get(manager -> new AnalyticsPageResource(box, (UISparkManager)manager, PlatformUiService.notifierProvider()).execute());
        PlatformUiService.initDisplays(spark);
    }

    public static void initDisplays(UIAlexandriaSpark spark) {
        ((UIRouter)spark.route("/sumusdesktop/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumusdesktop/:displayId")).post(manager -> new SumusDesktopRequester((UISparkManager)manager, PlatformUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/sumusdesktop/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumusnamespace/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumusnamespace/:displayId")).post(manager -> new SumusNameSpaceRequester((UISparkManager)manager, PlatformUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/sumusnamespace/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumuserror/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumuserror/:displayId")).post(manager -> new SumusErrorRequester((UISparkManager)manager, PlatformUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/sumuserror/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumusolap/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumusolap/:displayId")).post(manager -> new SumusOlapRequester((UISparkManager)manager, PlatformUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/sumusolap/:displayId")).get(manager -> new SumusOlapRequester((UISparkManager)manager, PlatformUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/sumusolap/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumusanalyze/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumusanalyze/:displayId")).post(manager -> new SumusAnalyzeRequester((UISparkManager)manager, PlatformUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/sumusanalyze/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumustimeserieschart/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumustimeserieschart/:displayId")).post(manager -> new SumusTimeSeriesChartRequester((UISparkManager)manager, PlatformUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/sumustimeserieschart/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumustimeserieschartdialog/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumustimeserieschartdialog/:displayId")).post(manager -> new SumusTimeSeriesChartDialogRequester((UISparkManager)manager, PlatformUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/sumustimeserieschartdialog/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumustimecrosstable/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumustimecrosstable/:displayId")).post(manager -> new SumusTimeCrossTableRequester((UISparkManager)manager, PlatformUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/sumustimecrosstable/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumustimecrosstabledialog/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumustimecrosstabledialog/:displayId")).post(manager -> new SumusTimeCrossTableDialogRequester((UISparkManager)manager, PlatformUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/sumustimecrosstabledialog/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumustimebarchart/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumustimebarchart/:displayId")).post(manager -> new SumusTimeBarChartRequester((UISparkManager)manager, PlatformUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/sumustimebarchart/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumustimebarchartdialog/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumustimebarchartdialog/:displayId")).post(manager -> new SumusTimeBarChartDialogRequester((UISparkManager)manager, PlatformUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/sumustimebarchartdialog/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumustimescatterchart/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumustimescatterchart/:displayId")).post(manager -> new SumusTimeScatterChartRequester((UISparkManager)manager, PlatformUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/sumustimescatterchart/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumustimescatterchartdialog/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumustimescatterchartdialog/:displayId")).post(manager -> new SumusTimeScatterChartDialogRequester((UISparkManager)manager, PlatformUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/sumustimescatterchartdialog/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumustimechartdesign/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumustimechartdesign/:displayId")).post(manager -> new SumusTimeChartDesignRequester((UISparkManager)manager, PlatformUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/sumustimechartdesign/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumusfilterlist/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumusfilterlist/:displayId")).post(manager -> new SumusFilterListRequester((UISparkManager)manager, PlatformUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/sumusfilterlist/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumusfilter/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumusfilter/:displayId")).post(manager -> new SumusFilterRequester((UISparkManager)manager, PlatformUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/sumusfilter/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumuscategorizationcomparator/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumuscategorizationcomparator/:displayId")).post(manager -> new SumusCategorizationComparatorRequester((UISparkManager)manager, PlatformUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/sumuscategorizationcomparator/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumuscategorization/:displayId")).before(manager -> new BeforeDisplayRequest(manager).execute());
        ((UIRouter)spark.route("/sumuscategorization/:displayId")).post(manager -> new SumusCategorizationRequester((UISparkManager)manager, PlatformUiService.notifierProvider()).execute());
        ((UIRouter)spark.route("/sumuscategorization/:displayId")).after(manager -> new AfterDisplayRequest(manager).execute());
        PlatformUiService.registerNotifiers();
    }

    private static void registerNotifiers() {
        PlatformUiService.register(SumusDesktopNotifier.class).forDisplay(SumusDesktop.class);
        PlatformUiService.register(SumusNameSpaceNotifier.class).forDisplay(SumusNameSpace.class);
        PlatformUiService.register(SumusErrorNotifier.class).forDisplay(SumusError.class);
        PlatformUiService.register(SumusOlapNotifier.class).forDisplay(SumusOlap.class);
        PlatformUiService.register(SumusAnalyzeNotifier.class).forDisplay(SumusAnalyze.class);
        PlatformUiService.register(SumusTimeSeriesChartNotifier.class).forDisplay(SumusTimeSeriesChart.class);
        PlatformUiService.register(SumusTimeSeriesChartDialogNotifier.class).forDisplay(SumusTimeSeriesChartDialog.class);
        PlatformUiService.register(SumusTimeCrossTableNotifier.class).forDisplay(SumusTimeCrossTable.class);
        PlatformUiService.register(SumusTimeCrossTableDialogNotifier.class).forDisplay(SumusTimeCrossTableDialog.class);
        PlatformUiService.register(SumusTimeBarChartNotifier.class).forDisplay(SumusTimeBarChart.class);
        PlatformUiService.register(SumusTimeBarChartDialogNotifier.class).forDisplay(SumusTimeBarChartDialog.class);
        PlatformUiService.register(SumusTimeScatterChartNotifier.class).forDisplay(SumusTimeScatterChart.class);
        PlatformUiService.register(SumusTimeScatterChartDialogNotifier.class).forDisplay(SumusTimeScatterChartDialog.class);
        PlatformUiService.register(SumusTimeChartDesignNotifier.class).forDisplay(SumusTimeChartDesign.class);
        PlatformUiService.register(SumusFilterListNotifier.class).forDisplay(SumusFilterList.class);
        PlatformUiService.register(SumusFilterNotifier.class).forDisplay(SumusFilter.class);
        PlatformUiService.register(SumusCategorizationComparatorNotifier.class).forDisplay(SumusCategorizationComparator.class);
        PlatformUiService.register(SumusCategorizationNotifier.class).forDisplay(SumusCategorization.class);
    }
}

