/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.analytics.viewmodels;

import io.intino.sumus.graph.AbstractMetric;
import io.intino.sumus.graph.Indicator;
import io.intino.sumus.graph.MeasureIndicator;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.queries.TimeSeriesQuery;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class Histogram {
    private final Map<Ticket, HistogramTicket> ticketList = new HashMap<Ticket, HistogramTicket>();
    protected List<String> tagList = new ArrayList<String>();
    protected TimeSeriesQuery.SortBy sortBy = null;

    public Histogram(List<String> tagList) {
        this(tagList, null);
    }

    public Histogram(List<String> tagList, TimeSeriesQuery.SortBy sortBy) {
        this.tagList.addAll(tagList);
        this.sortBy = sortBy;
    }

    public HistogramTicket histogramTicket(Ticket ticket) {
        if (!this.ticketList.containsKey((Object)ticket)) {
            this.ticketList.put(ticket, new HistogramTicket(ticket));
        }
        return this.ticketList.get((Object)ticket);
    }

    public List<String> tags() {
        if (this.sortBy == null) {
            return this.tagList;
        }
        return HistogramIndicator.sort(this.tagList, this.sortBy.mode());
    }

    public List<HistogramTicket> tickets() {
        return new ArrayList<HistogramTicket>(this.ticketList.values());
    }

    private Optional<HistogramIndicator> histogramIndicator(Ticket ticket, MeasureIndicator indicator) {
        return Optional.ofNullable(this.histogramTicket(ticket).indicators.get((Object)indicator));
    }

    public static class HistogramIndicator {
        private final MeasureIndicator indicator;
        private final String color;
        private final List<Double> values = new ArrayList<Double>();
        private final Ticket.DecimalPlaces decimalPlaces;
        private Double minValue = null;
        private Double maxValue = null;

        public HistogramIndicator(MeasureIndicator indicator, String label, String color, Ticket.DecimalPlaces decimalPlaces) {
            this.indicator = indicator;
            this.color = color;
            this.decimalPlaces = decimalPlaces;
        }

        static List<String> sort(List<String> tagList, TimeSeriesQuery.SortBy.Mode mode) {
            tagList.sort(HistogramIndicator.labelSorting(mode));
            return tagList;
        }

        private static Comparator<String> labelSorting(TimeSeriesQuery.SortBy.Mode mode) {
            return (o1, o2) -> {
                if (mode == TimeSeriesQuery.SortBy.Mode.Ascendant) {
                    return o1.compareTo((String)o2);
                }
                return o2.compareTo((String)o1);
            };
        }

        public Indicator indicator() {
            return this.indicator;
        }

        public String label() {
            return this.indicator.label();
        }

        public List<Double> values() {
            return this.values;
        }

        public AbstractMetric.Unit unit() {
            return this.indicator.unit();
        }

        public Ticket.DecimalPlaces decimalPlaces() {
            return this.decimalPlaces;
        }

        public double minValue() {
            return this.minValue != null ? this.minValue : 0.0;
        }

        public double maxValue() {
            return this.maxValue != null ? this.maxValue : 0.0;
        }

        public String color() {
            return this.color;
        }

        public void register(List<Double> values) {
            this.values.addAll(values.stream().map(v -> v == null ? 0.0 : v).collect(Collectors.toList()));
            this.updateBounds();
        }

        private void updateBounds() {
            boolean empty = this.values.isEmpty();
            this.minValue = !empty ? this.values.stream().filter(Objects::nonNull).min(Double::compare).orElse(0.0) : Double.valueOf(0.0);
            this.maxValue = !empty ? this.values.stream().filter(Objects::nonNull).max(Double::compare).orElse(0.0) : Double.valueOf(0.0);
        }
    }

    public static class HistogramTicket {
        private final Ticket ticket;
        private final Map<MeasureIndicator, HistogramIndicator> indicators = new HashMap<MeasureIndicator, HistogramIndicator>();

        HistogramTicket(Ticket ticket) {
            this.ticket = ticket;
        }

        public Ticket ticket() {
            return this.ticket;
        }

        public void register(HistogramIndicator indicator) {
            this.indicators.put(indicator.indicator, indicator);
        }

        public List<HistogramIndicator> indicators() {
            return new ArrayList<HistogramIndicator>(this.indicators.values());
        }

        public String name() {
            return this.ticket.name$();
        }

        public String label() {
            return this.ticket.label();
        }

        public String shortLabel() {
            return this.ticket.shortLabel();
        }

        public double maxValue() {
            return this.indicators.values().stream().mapToDouble(HistogramIndicator::maxValue).max().orElse(0.0);
        }

        public List<Double> values() {
            List<Double> values = this.indicators.values().iterator().next().values().stream().map(i -> 0.0).collect(Collectors.toList());
            for (HistogramIndicator indicator : this.indicators.values()) {
                List<Double> indicatorValues = indicator.values();
                for (int i2 = 0; i2 < indicatorValues.size(); ++i2) {
                    values.set(i2, values.get(i2) + indicatorValues.get(i2));
                }
            }
            return values;
        }
    }
}

