/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.analytics.categorization;

import io.intino.alexandria.ui.model.TimeRange;
import io.intino.alexandria.ui.model.TimeScale;
import io.intino.sumus.graph.AbstractAccess;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.helpers.TranslatorHelper;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class TemporalCategorization
extends Categorization {
    protected String name;
    protected String format;
    protected TranslatorHelper helper;
    protected String language;
    protected TimeRange range;
    protected List<Tag> tags = new ArrayList<Tag>();

    public TemporalCategorization(String name, String format, Categorization parent, TimeRange range) {
        super(null);
        this.name = name;
        this.parent = parent;
        this.format = format;
        this.update(range);
        this.createTags();
    }

    public TemporalCategorization(TimeRange range) {
        this("TemporalCategorization", "", null, range);
    }

    public TemporalCategorization helper(TranslatorHelper helper) {
        this.helper = helper;
        this.setup();
        return this;
    }

    @Override
    public Categorization parent() {
        return this.parent;
    }

    private void update(TimeRange timeRange) {
        TimeScale scale = timeRange.scale();
        this.range = new TimeRange(scale.normalise(timeRange.from()), scale.normalise(timeRange.to()), scale);
        Optional.ofNullable(this.parent()).ifPresent(parent -> ((TemporalCategorization)((Object)parent)).update(timeRange));
    }

    public TemporalCategorization language(String language) {
        this.language = language;
        this.setup();
        return this;
    }

    public String name$() {
        return this.name;
    }

    public TimeRange range() {
        return this.range;
    }

    public String format() {
        return this.format;
    }

    public boolean isAvailableForScale(TimeScale scale) {
        return scale.ordinal() >= this.range().scale().ordinal();
    }

    public void range(TimeRange timeRange) {
        this.update(timeRange);
    }

    private void setup() {
        if (this.helper == null || this.language == null) {
            return;
        }
        this.label(this.helper.translate(this.name).into(this.language));
    }

    private void createTags() {
        this.range.allInstants().forEach(instant -> this.tags.add(new Tag((Instant)instant, this.range.scale().sortingWeight(instant, this.format))));
    }

    @Override
    public List<String> tags(List<AbstractAccess> accessList) {
        ArrayList<Tag> tags = new ArrayList<Tag>(this.tags);
        tags.sort(Comparator.comparingInt(c -> c.weight));
        return tags.stream().map(t -> this.labelOf(t.instant)).collect(Collectors.toList());
    }

    private String labelOf(Instant instant) {
        return this.range.scale().toString(instant);
    }

    private class Tag {
        Instant instant;
        int weight;

        Tag(Instant instant, int weight) {
            this.instant = instant;
            this.weight = weight;
        }
    }
}

