/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries.temporalrecord;

import io.intino.sumus.TimeStamp;
import io.intino.sumus.datawarehouse.store.PathBuilder;
import io.intino.sumus.graph.AbstractCategorization;
import io.intino.sumus.graph.SumusGraph;
import io.intino.sumus.graph.TemporalRecord;
import io.intino.sumus.queries.temporalrecord.Query;
import io.intino.sumus.queries.temporalrecord.QueryResult;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Graph;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class QueryExecutor {
    private final Query query;
    private final List<AbstractCategorization.RecordTagger> taggers;
    private final QueryResult result;

    private QueryExecutor(Query query) {
        this.query = query;
        this.taggers = query.nameSpace().graph().categorizationList().stream().map(t -> t.recordTaggerOf(query.temporalRecord())).filter(Objects::nonNull).collect(Collectors.toList());
        this.result = new QueryResult(query);
    }

    public static QueryResult execute(Query query) {
        QueryExecutor executor = new QueryExecutor(query);
        executor.execute();
        return executor.result;
    }

    private void execute() {
        SumusGraph graph = this.query.nameSpace().graph();
        List<Concept> concepts = this.subConceptsOf(graph, this.query.temporalRecord());
        for (TimeStamp timeStamp : this.query.timeStamps()) {
            Graph clone = this.query.nameSpace().graph().core$().clone();
            this.loadStashes(clone, concepts, timeStamp);
            clone.rootList(this.query.temporalRecord().layerClass()).stream().map(e -> (TemporalRecord)e.a$(TemporalRecord.class)).filter(this::isInFilter).filter(this::hasCondition).forEach(this.result::register);
        }
    }

    private List<Concept> subConceptsOf(SumusGraph graph, Concept concept) {
        return graph.core$().conceptList().stream().filter(c -> c.is(concept.name())).collect(Collectors.toList());
    }

    private void loadStashes(Graph graph, List<Concept> concepts, TimeStamp timeStamp) {
        concepts.forEach(tr -> graph.loadStashes(new String[]{PathBuilder.temporalRecordPath(this.query.nameSpace(), tr, timeStamp)}));
    }

    private boolean hasCondition(TemporalRecord temporalRecord) {
        String condition = this.query.condition();
        if (condition == null || condition.isEmpty()) {
            return true;
        }
        List<String> keys = Arrays.asList(condition.toLowerCase().split(" "));
        List words = temporalRecord.core$().variables().values().stream().flatMap(Collection::stream).filter(s -> s instanceof String).map(s -> (String)s).collect(Collectors.toList());
        return keys.stream().filter(key -> words.stream().filter(word -> word.toLowerCase().contains((CharSequence)key)).count() > 0L).count() == (long)keys.size();
    }

    private boolean isInFilter(TemporalRecord temporalRecord) {
        return this.query.filter() == null || this.query.filter().contains(this.tagsOf(temporalRecord));
    }

    private Collection<String> tagsOf(TemporalRecord temporalRecord) {
        return temporalRecord.graph().categorizationList().stream().map(c -> c.recordTaggerOf(temporalRecord)).filter(Objects::nonNull).map(c -> c.tag(temporalRecord)).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

