/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries.digest;

import io.intino.sumus.TimeStamp;
import io.intino.sumus.datawarehouse.store.Digest;
import io.intino.sumus.graph.MeasureIndicator;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.queries.Drill;
import io.intino.sumus.queries.digest.Query;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class QueryResult {
    private Query query;
    private Map<String, Double> values = new ConcurrentHashMap<String, Double>();
    private List<Digest> digests = Collections.synchronizedList(new ArrayList());

    QueryResult(Query query) {
        this.query = query;
    }

    void register(List<Digest> digest) {
        this.digests.addAll(digest);
    }

    void register(Query.SubQuery query, TimeStamp stamp, double value) {
        this.values.put(query.toString() + stamp.toString(), value);
    }

    void register(Query.SubQuery query, Drill drill, TimeStamp stamp, double value) {
        if (drill.isTemporal()) {
            this.values.put(query.toString() + drill.toString(), value);
        } else {
            this.values.put(query.toString() + drill.toString() + stamp.toString(), value);
        }
    }

    public Double value(NameSpace nameSpace, MeasureIndicator.Formula formula, TimeStamp stamp) {
        return this.values.get(this.query.subQuery(nameSpace, formula).toString() + stamp.toString());
    }

    public Double value(NameSpace nameSpace, MeasureIndicator.Formula formula, Drill drill) {
        return this.values.get(this.query.subQuery(nameSpace, formula).toString() + drill.toString());
    }

    public Double value(NameSpace nameSpace, MeasureIndicator.Formula formula, Drill drill, TimeStamp stamp) {
        return this.values.get(this.query.subQuery(nameSpace, formula).toString() + drill.toString() + stamp.toString());
    }

    public Map<TimeStamp, Double> values(NameSpace nameSpace, MeasureIndicator.Formula formula) {
        return this.values(nameSpace, formula, null);
    }

    public Map<TimeStamp, Double> values(NameSpace nameSpace, MeasureIndicator.Formula formula, Drill drill) {
        return this.values(this.query.subQuery(nameSpace, formula), drill);
    }

    private Map<TimeStamp, Double> values(Query.SubQuery query, Drill drill) {
        String prefix = query.toString() + (drill != null ? drill.toString() : "");
        LinkedHashMap<TimeStamp, Double> values = new LinkedHashMap<TimeStamp, Double>();
        for (TimeStamp stamp : query.timeStamps()) {
            Double value = this.values().get(prefix + stamp.toString());
            if (value == null) continue;
            values.put(stamp, value);
        }
        return values;
    }

    public Query query() {
        return this.query;
    }

    public Map<String, Double> values() {
        return this.values;
    }

    public List<Digest> digests() {
        return this.digests;
    }
}

