/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries;

import io.intino.konos.alexandria.ui.model.TimeRange;
import io.intino.konos.alexandria.ui.model.TimeScale;
import io.intino.sumus.TimeStamp;
import io.intino.sumus.analytics.FormulaLoader;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.MeasureIndicator;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.queries.AbstractQuery;
import io.intino.sumus.queries.digest.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TimeSeriesQuery
extends AbstractQuery {
    private final List<Ticket> tickets = new ArrayList<Ticket>();
    private final Map<Categorization, Set<String>> drills = new HashMap<Categorization, Set<String>>();
    private final Map<Categorization, List<String>> filters = new HashMap<Categorization, List<String>>();
    private NameSpace nameSpace;
    private TimeRange timeRange;
    private TimeStamp timeStamp;
    private boolean includeGlobalSerie;

    private TimeSeriesQuery() {
    }

    public NameSpace nameSpace() {
        return this.nameSpace;
    }

    public TimeRange timeRange() {
        return this.timeRange;
    }

    public List<Ticket> tickets() {
        return this.tickets;
    }

    public Map<Categorization, List<String>> filters() {
        return this.filters;
    }

    public Map<Categorization, Set<String>> drills() {
        return this.drills;
    }

    public boolean includeGlobalSerie() {
        return this.includeGlobalSerie;
    }

    public Query toRawQuery(FormulaLoader loader) {
        Query result = new Query();
        this.addScope(result);
        loader.formulas(this.tickets).forEach(formula -> result.add(this.nameSpace, (MeasureIndicator.Formula)((Object)formula)));
        if (this.timeRange != null) {
            result.add(this.timeRange);
        }
        if (this.timeStamp != null) {
            result.add(this.timeStamp);
        }
        this.filters.values().forEach(result::filter);
        this.drills.values().forEach(tags -> tags.forEach(result::drill));
        return result;
    }

    public TimeScale scale() {
        return this.timeRange != null ? this.timeRange.scale() : this.timeStamp.scale();
    }

    public static class SortBy {
        private final Ticket ticket;
        private final MeasureIndicator indicator;
        private final Mode mode;

        public SortBy(Ticket ticket, MeasureIndicator indicator, Mode mode) {
            this.ticket = ticket;
            this.indicator = indicator;
            this.mode = mode;
        }

        public Ticket ticket() {
            return this.ticket;
        }

        public MeasureIndicator indicator() {
            return this.indicator;
        }

        public Mode mode() {
            return this.mode;
        }

        public static enum Mode {
            Ascendant,
            Descendant;

        }
    }

    public static class Builder
    extends AbstractQuery.Builder<TimeSeriesQuery> {
        public Builder() {
            super(new TimeSeriesQuery());
        }

        public TimeSeriesQuery build(NameSpace nameSpace, TimeRange timeRange) {
            this.nameSpace(nameSpace);
            this.timeRange(timeRange);
            return (TimeSeriesQuery)this.query;
        }

        public TimeSeriesQuery build(NameSpace nameSpace, TimeStamp timeStamp) {
            this.nameSpace(nameSpace);
            this.timeStamp(timeStamp);
            return (TimeSeriesQuery)this.query;
        }

        public Builder addTicket(Ticket ticket) {
            ((TimeSeriesQuery)this.query).tickets.add(ticket);
            return this;
        }

        public Builder addTickets(List<Ticket> tickets) {
            ((TimeSeriesQuery)this.query).tickets.addAll(tickets);
            return this;
        }

        public Builder filter(Categorization categorization, List<String> tag) {
            ((TimeSeriesQuery)this.query).filters.put(categorization, tag);
            return this;
        }

        public Builder drill(Categorization categorization, String tag) {
            ((TimeSeriesQuery)this.query).drills.putIfAbsent(categorization, new HashSet());
            Set tags = (Set)((TimeSeriesQuery)this.query).drills.get((Object)categorization);
            tags.remove(tag);
            tags.add(tag);
            return this;
        }

        public Builder drill(Categorization categorization, List<String> tags) {
            tags.forEach(c -> this.drill(categorization, (String)c));
            return this;
        }

        private Builder timeRange(TimeRange timeRange) {
            ((TimeSeriesQuery)this.query).timeRange = timeRange;
            return this;
        }

        private Builder timeStamp(TimeStamp timeStamp) {
            ((TimeSeriesQuery)this.query).timeStamp = timeStamp;
            return this;
        }

        public void includeGlobalSerie(boolean value) {
            ((TimeSeriesQuery)this.query).includeGlobalSerie = value;
        }

        public void nameSpace(NameSpace nameSpace) {
            ((TimeSeriesQuery)this.query).nameSpace = nameSpace;
        }
    }
}

