/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.queries;

import io.intino.konos.alexandria.ui.model.TimeRange;
import io.intino.konos.alexandria.ui.model.TimeScale;
import io.intino.sumus.analytics.FormulaLoader;
import io.intino.sumus.analytics.viewmodels.FilterCondition;
import io.intino.sumus.graph.AbstractAccess;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.MeasureIndicator;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.queries.AbstractQuery;
import io.intino.sumus.queries.TimeSeriesQuery;
import io.intino.sumus.queries.digest.Query;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HistogramQuery
extends AbstractQuery {
    private final List<Ticket> tickets = new ArrayList<Ticket>();
    private final Map<Categorization, List<String>> filters = new HashMap<Categorization, List<String>>();
    private TimeSeriesQuery.SortBy sortBy = null;
    private Categorization categorization = null;
    private NameSpace nameSpace;
    private TimeRange timeRange;
    private List<AbstractAccess> accessList = new ArrayList<AbstractAccess>();

    private HistogramQuery() {
    }

    public List<Ticket> tickets() {
        return this.tickets;
    }

    public Categorization categorization() {
        return this.categorization;
    }

    public Map<Categorization, List<String>> filters() {
        return this.filters;
    }

    public TimeSeriesQuery.SortBy sortBy() {
        return this.sortBy;
    }

    public NameSpace nameSpace() {
        return this.nameSpace;
    }

    public TimeRange timeRange() {
        return this.timeRange;
    }

    public List<AbstractAccess> accessList() {
        return this.accessList;
    }

    public Query toRawQuery(FormulaLoader loader, List<String> tags) {
        Query result = new Query();
        this.addScope(result);
        loader.formulas(this.tickets).forEach(formula -> result.add(this.nameSpace, (MeasureIndicator.Formula)((Object)formula)));
        result.add(this.timeRange);
        this.filters().values().forEach(result::filter);
        tags.forEach(result::drill);
        return result;
    }

    public TimeScale scale() {
        return this.timeRange.scale();
    }

    public static class Builder
    extends AbstractQuery.Builder<HistogramQuery> {
        public Builder() {
            super(new HistogramQuery());
        }

        public HistogramQuery build(NameSpace nameSpace, Categorization categorization, TimeRange timeRange, TimeSeriesQuery.SortBy sortBy) {
            this.nameSpace(nameSpace);
            this.categorization(categorization);
            this.timeRange(timeRange);
            this.sortBy(sortBy);
            return (HistogramQuery)this.query;
        }

        public Builder addTickets(List<Ticket> tickets) {
            ((HistogramQuery)this.query).tickets.addAll(tickets);
            return this;
        }

        public Builder addTicket(Ticket ticket) {
            ((HistogramQuery)this.query).tickets.add(ticket);
            return this;
        }

        private Builder nameSpace(NameSpace nameSpace) {
            ((HistogramQuery)this.query).nameSpace = nameSpace;
            return this;
        }

        private Builder timeRange(TimeRange timeRange) {
            ((HistogramQuery)this.query).timeRange = timeRange;
            return this;
        }

        private Builder categorization(Categorization categorization) {
            ((HistogramQuery)this.query).categorization = categorization;
            return this;
        }

        private Builder sortBy(TimeSeriesQuery.SortBy sortBy) {
            ((HistogramQuery)this.query).sortBy = sortBy;
            return this;
        }

        public Builder filter(Categorization categorization, List<String> tag) {
            ((HistogramQuery)this.query).filters.put(categorization, tag);
            return this;
        }

        public Builder filter(List<FilterCondition> filterConditions) {
            filterConditions.forEach(filter -> ((HistogramQuery)this.query).filters.put(filter.categorization, filter.tags));
            return this;
        }

        public Builder accessList(List<AbstractAccess> accessList) {
            ((HistogramQuery)this.query).accessList = accessList;
            return this;
        }
    }
}

