/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.helpers;

import io.intino.sumus.TimeStamp;
import io.intino.sumus.analytics.viewmodels.Serie;
import io.intino.sumus.graph.MeasureIndicator;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.helpers.QueryHelper;
import io.intino.sumus.queries.Drill;
import io.intino.sumus.queries.TimeSeriesQuery;
import io.intino.sumus.queries.digest.Query;
import io.intino.sumus.queries.digest.QueryExecutor;
import io.intino.sumus.queries.digest.QueryResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TimeSeriesHelper
extends QueryHelper {
    private static final String GlobalSerieColor = "#DDD";

    public synchronized List<Serie> execute(TimeSeriesQuery timeSeriesQuery) {
        Query query = this.queryOf(timeSeriesQuery);
        QueryResult rawData = QueryExecutor.execute(query);
        ArrayList<Serie> result = new ArrayList<Serie>();
        query.nameSpaces().forEach(nameSpace -> query.formulas().forEach(formula -> {
            if (!query.drills().isEmpty()) {
                if (timeSeriesQuery.includeGlobalSerie()) {
                    result.add(this.createGlobalSerie((MeasureIndicator.Formula)((Object)((Object)formula)), query, rawData.values((NameSpace)((Object)nameSpace), (MeasureIndicator.Formula)((Object)((Object)formula)))));
                }
            } else {
                result.add(this.createSerie((MeasureIndicator.Formula)((Object)((Object)formula)), query, rawData.values((NameSpace)((Object)nameSpace), (MeasureIndicator.Formula)((Object)((Object)formula)))));
            }
            query.drills().forEach(drill -> result.add(this.createSerie((MeasureIndicator.Formula)((Object)((Object)formula)), query, rawData.values((NameSpace)((Object)nameSpace), (MeasureIndicator.Formula)((Object)((Object)formula)), (Drill)drill), (Drill)drill)));
        }));
        this.scaleValues(result);
        return result;
    }

    public List<String> entities(TimeSeriesQuery timeSeriesQuery) {
        Query query = this.queryOf(timeSeriesQuery);
        QueryResult rawData = QueryExecutor.execute(query);
        HashSet entities = new HashSet();
        rawData.digests().forEach(d -> entities.addAll(d.dimensionIdsSplit()));
        return new ArrayList<String>(entities);
    }

    private Serie createSerie(MeasureIndicator.Formula formula, Query query, Map<TimeStamp, Double> values) {
        return this.createSerie(formula, query, this.labelOf(formula), this.colorOf(this.indicatorOf(formula)), values);
    }

    private Serie createSerie(MeasureIndicator.Formula formula, Query query, Map<TimeStamp, Double> values, Drill drill) {
        int drillIndex = this.drillIndexOf(drill, query);
        return this.createSerie(formula, query, this.labelOf(formula, drill), this.colorOf(this.indicatorOf(formula), drillIndex), values);
    }

    private Serie createGlobalSerie(MeasureIndicator.Formula formula, Query query, Map<TimeStamp, Double> values) {
        Serie serie = this.createSerie(formula, query, this.labelOf(formula), GlobalSerieColor, values);
        serie.asGlobalSerie();
        return serie;
    }

    private Serie createSerie(MeasureIndicator.Formula formula, Query query, String label, String color, Map<TimeStamp, Double> values) {
        Ticket ticket = this.ticketOf(formula);
        Serie serie = new Serie(ticket, this.indicatorOf(formula), label, color);
        boolean fillWithZeros = ticket.style().line() == Ticket.Style.Line.ContinuousWithZeros;
        query.timeStamps().forEach(timeStamp -> {
            if (!fillWithZeros && !values.containsKey(timeStamp)) {
                return;
            }
            Double value = (Double)values.get(timeStamp);
            serie.register(timeStamp.instant(), value != null ? value : 0.0);
        });
        return serie;
    }

    private Query queryOf(TimeSeriesQuery query) {
        return query.toRawQuery(tickets -> this.formulas(this.measureIndicators(query.tickets(), query.scale())));
    }
}

