/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.helpers;

import io.intino.konos.alexandria.ui.model.TimeRange;
import io.intino.sumus.analytics.categorization.TemporalCategorization;
import io.intino.sumus.analytics.viewmodels.Drill;
import io.intino.sumus.analytics.viewmodels.FilterCondition;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Ticket;
import io.intino.sumus.helpers.ChartSpec;
import io.intino.sumus.queries.Scope;
import io.intino.tara.magritte.Concept;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ChartSpecHandler {
    private boolean dirty = false;
    private List<Ticket> olapTicketList = new ArrayList<Ticket>();
    private CategorizationsLoader categorizationsLoader = null;
    private List<Consumer<ChartSpec>> changeListeners = new ArrayList<Consumer<ChartSpec>>();
    private ChartSpec spec = new ChartSpec();

    public void onChange(Consumer<ChartSpec> listener) {
        this.changeListeners.add(listener);
    }

    public ChartSpec specification() {
        return this.spec;
    }

    public List<Ticket> olapTickets() {
        return this.olapTicketList;
    }

    public void olapTickets(List<Ticket> olapTicketList) {
        this.olapTicketList.clear();
        this.olapTicketList.addAll(olapTicketList);
    }

    public List<Categorization> olapCategorizations() {
        return this.categorizationsLoader != null ? this.categorizationsLoader.categorizations() : Collections.emptyList();
    }

    public List<TemporalCategorization> olapTemporalCategorizations() {
        return this.categorizationsLoader != null ? this.categorizationsLoader.temporalCategorizations() : Collections.emptyList();
    }

    public ChartSpecHandler olapCategorizationsLoader(CategorizationsLoader categorizationsLoader) {
        this.categorizationsLoader = categorizationsLoader;
        return this;
    }

    public List<Ticket> selectedTickets() {
        return this.spec.ticketList();
    }

    public void clearTicketsTag(String tag) {
        this.spec.clearTicketsTag(tag);
    }

    public void setScope(Scope scope) {
        this.spec.scope(scope);
        this.dirty = true;
    }

    public void setTicketTags(Ticket ticket, List<String> tags) {
        this.spec.clearTags(ticket);
        this.spec.addTags(ticket, tags);
        this.dirty = true;
    }

    public void selectTickets(String ... tickets) {
        List<Ticket> ticketList = Stream.of(tickets).map(this::ticketOf).collect(Collectors.toList());
        this.selectTickets(ticketList);
        this.dirty = true;
    }

    public void selectTickets(List<Ticket> ticketList) {
        if (this.spec.equalsTickets(ticketList)) {
            return;
        }
        List<Ticket> specTicketList = this.spec.ticketList();
        specTicketList.clear();
        ticketList.forEach(specTicketList::add);
        this.dirty = true;
    }

    public void selectTickets(Map<Ticket, List<String>> taggedTicketList) {
        List<Ticket> specTicketList = this.spec.ticketList();
        specTicketList.clear();
        taggedTicketList.entrySet().forEach(entry -> {
            Ticket ticket = (Ticket)((Object)((Object)entry.getKey()));
            specTicketList.add(ticket);
            this.spec.addTags(ticket, (List<String>)((List)entry.getValue()));
        });
        this.dirty = true;
    }

    public void addTicket(Ticket ticket) {
        List<Ticket> specTicketList = this.spec.ticketList();
        if (specTicketList.contains((Object)ticket)) {
            return;
        }
        specTicketList.add(ticket);
        this.dirty = true;
    }

    public void removeTicket(Ticket ticket) {
        this.spec.ticketList().remove((Object)ticket);
        this.dirty = true;
    }

    public void clearCategorizationsTag(String tag) {
        this.spec.clearCategorizationsTag(tag);
        this.dirty = true;
    }

    public void selectCategorizations(Map<Categorization, List<String>> taggedCategorizationList) {
        List<Categorization> specCategorizationList = this.spec.categorizationList();
        taggedCategorizationList.entrySet().forEach(entry -> {
            Categorization categorization = (Categorization)((Object)((Object)entry.getKey()));
            if (!specCategorizationList.contains((Object)categorization)) {
                specCategorizationList.add(categorization);
            }
            this.spec.addTags(categorization, (List<String>)((List)entry.getValue()));
        });
        this.dirty = true;
    }

    public void range(TimeRange range) {
        this.spec.range(range);
        this.dirty = true;
    }

    public void heatMap(ChartSpec.HeatMap heatMap) {
        this.spec.heatMap(heatMap);
        this.dirty = true;
    }

    public void filter(List<FilterCondition> conditionList) {
        this.spec.filterList().clear();
        this.spec.filterList().addAll(conditionList);
        this.dirty = true;
    }

    public Drill drill() {
        return this.spec.drill();
    }

    public void drill(Drill drill) {
        this.drill(drill, this.spec.includeGlobalSerie());
    }

    public void drill(Drill drill, boolean includeGlobalSerie) {
        if (this.spec.equalsDrill(drill) && this.spec.includeGlobalSerie() == includeGlobalSerie) {
            return;
        }
        this.spec.drill(drill, includeGlobalSerie);
        this.dirty = true;
    }

    public Drill removeDrillTag(String tagName) {
        Drill drill = this.spec.drill();
        drill.removeTag(tagName);
        this.dirty = true;
        return drill;
    }

    public void eventTypes(List<Concept> eventTypes) {
        this.spec.eventTypes(eventTypes);
        this.dirty = true;
    }

    public void update() {
        if (!this.dirty) {
            return;
        }
        this.notifySpecChanged();
        this.dirty = false;
    }

    private void notifySpecChanged() {
        this.changeListeners.parallelStream().forEach(l -> l.accept(this.spec));
    }

    private Ticket ticketOf(String key) {
        return this.olapTicketList.stream().filter((? super T t) -> t.name$().equals(key) || t.label().equals(key)).findFirst().orElse(null);
    }

    private Categorization categorizationOf(String key) {
        return this.allCategorizations().stream().filter((? super T c) -> c.name$().equals(key) || c.label().equals(key)).findFirst().orElse(null);
    }

    private List<Categorization> allCategorizations() {
        ArrayList<Categorization> result = new ArrayList<Categorization>();
        result.addAll(this.olapCategorizations());
        result.addAll(this.olapTemporalCategorizations());
        return result;
    }

    public static interface CategorizationsLoader {
        public List<Categorization> categorizations();

        public List<TemporalCategorization> temporalCategorizations();
    }
}

