/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.sumus.graph.Record;
import io.intino.sumus.graph.SumusGraph;
import io.intino.sumus.graph.aspect.AspectEntity;
import io.intino.sumus.graph.dynamic.DynamicEntity;
import io.intino.sumus.graph.geolocated.GeolocatedEntity;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Entity
extends Record {
    protected List<Entity> entityList = new ArrayList<Entity>();

    public Entity(Node node) {
        super(node);
    }

    public List<Entity> entityList() {
        return Collections.unmodifiableList(this.entityList);
    }

    public Entity entity(int index) {
        return this.entityList.get(index);
    }

    public List<Entity> entityList(Predicate<Entity> predicate) {
        return this.entityList().stream().filter(predicate).collect(Collectors.toList());
    }

    public DynamicEntity asDynamic() {
        return (DynamicEntity)this.a$(DynamicEntity.class);
    }

    public DynamicEntity asDynamic(Instant created) {
        DynamicEntity newElement = (DynamicEntity)this.core$().addFacet(DynamicEntity.class);
        newElement.core$().set((Layer)newElement, "created", Collections.singletonList(created));
        return newElement;
    }

    public boolean isDynamic() {
        return this.core$().is(DynamicEntity.class);
    }

    public void removeDynamic() {
        this.core$().removeFacet(DynamicEntity.class);
    }

    public AspectEntity asAspect() {
        Layer as = this.a$(AspectEntity.class);
        return as != null ? (AspectEntity)as : (AspectEntity)this.core$().addFacet(AspectEntity.class);
    }

    public boolean isAspect() {
        return this.core$().is(AspectEntity.class);
    }

    public GeolocatedEntity asGeolocated() {
        return (GeolocatedEntity)this.a$(GeolocatedEntity.class);
    }

    public GeolocatedEntity asGeolocated(double x, double y) {
        GeolocatedEntity newElement = (GeolocatedEntity)this.core$().addFacet(GeolocatedEntity.class);
        newElement.core$().set((Layer)newElement, "x", Collections.singletonList(x));
        newElement.core$().set((Layer)newElement, "y", Collections.singletonList(y));
        return newElement;
    }

    public boolean isGeolocated() {
        return this.core$().is(GeolocatedEntity.class);
    }

    public void removeGeolocated() {
        this.core$().removeFacet(GeolocatedEntity.class);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Entity>(this.entityList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Entity")) {
            this.entityList.add((Entity)node.as(Entity.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Entity")) {
            this.entityList.remove(node.as(Entity.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    @Override
    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public class Clear {
        public void entity(Predicate<Entity> filter) {
            new ArrayList<Entity>(Entity.this.entityList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends Record.Create {
        public Create(String name) {
            super(Entity.this, name);
        }

        public Entity entity() {
            Entity newElement = (Entity)Entity.this.core$().graph().concept(Entity.class).createNode(this.name, Entity.this.core$()).as(Entity.class);
            return newElement;
        }
    }
}

