/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.sumus.graph.AbstractAccess;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.NameSpace;
import io.intino.sumus.graph.SumusGraph;
import io.intino.tara.magritte.Expression;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.FunctionLoader;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Access
extends AbstractAccess
implements Terminal {
    protected List<NameSpace> namespaces = new ArrayList<NameSpace>();
    protected List<Tags> tagsList = new ArrayList<Tags>();

    public Access(Node node) {
        super(node);
    }

    public List<NameSpace> namespaces() {
        return this.namespaces;
    }

    public NameSpace namespaces(int index) {
        return this.namespaces.get(index);
    }

    public List<NameSpace> namespaces(Predicate<NameSpace> predicate) {
        return this.namespaces().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Tags> tagsList() {
        return Collections.unmodifiableList(this.tagsList);
    }

    public Tags tags(int index) {
        return this.tagsList.get(index);
    }

    public List<Tags> tagsList(Predicate<Tags> predicate) {
        return this.tagsList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Tags>(this.tagsList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("namespaces", this.namespaces);
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Access$Tags")) {
            this.tagsList.add((Tags)node.as(Tags.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Access$Tags")) {
            this.tagsList.remove(node.as(Tags.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("namespaces")) {
            this.namespaces = NodeLoader.load(values, NameSpace.class, (Layer)this);
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("namespaces")) {
            this.namespaces = values.stream().map(s -> (NameSpace)this.graph().core$().load(((Layer)s).core$().id()).as(NameSpace.class)).collect(Collectors.toList());
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    @Override
    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public static class Tags
    extends Layer
    implements Terminal {
        protected Expression<List<String>> tags;
        protected Categorization categorization;

        public Tags(Node node) {
            super(node);
        }

        public List<String> tags() {
            return (List)this.tags.value();
        }

        public Categorization categorization() {
            return this.categorization;
        }

        public Tags categorization(Categorization value) {
            this.categorization = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("tags", this.tags != null ? new ArrayList<Expression<List<String>>>(Collections.singletonList(this.tags)) : Collections.emptyList());
            map.put("categorization", this.categorization != null ? new ArrayList<Categorization>(Collections.singletonList(this.categorization)) : Collections.emptyList());
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("tags")) {
                this.tags = (Expression)FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
            } else if (name.equalsIgnoreCase("categorization")) {
                this.categorization = (Categorization)((Object)NodeLoader.load(values, Categorization.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("tags")) {
                this.tags = (Expression)FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
            } else if (name.equalsIgnoreCase("categorization")) {
                this.categorization = values.get(0) != null ? (Categorization)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Categorization.class) : null;
            }
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }
    }

    public class Clear {
        public void tags(Predicate<Tags> filter) {
            new ArrayList<Tags>(Access.this.tagsList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends AbstractAccess.Create {
        public Create(String name) {
            super(Access.this, name);
        }

        public Tags tags(Expression<List<String>> tags, Categorization categorization) {
            Tags newElement = (Tags)Access.this.core$().graph().concept(Tags.class).createNode(this.name, Access.this.core$()).as(Tags.class);
            newElement.core$().set((Layer)newElement, "tags", Collections.singletonList(tags));
            newElement.core$().set((Layer)newElement, "categorization", Collections.singletonList(categorization));
            return newElement;
        }
    }
}

