/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.sumus.analytics.MetricScaler;
import io.intino.sumus.graph.Metric;
import io.intino.sumus.graph.SumusGraph;
import io.intino.sumus.graph.TemporalMetric;
import io.intino.sumus.graph.functions.Converter;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.ObjectLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractMetric
extends Layer
implements Terminal {
    protected MetricScaler scaler;
    protected List<Unit> unitList = new ArrayList<Unit>();

    public AbstractMetric(Node node) {
        super(node);
    }

    public MetricScaler scaler() {
        return this.scaler;
    }

    public AbstractMetric scaler(MetricScaler value) {
        this.scaler = value;
        return this;
    }

    public List<Unit> unitList() {
        return Collections.unmodifiableList(this.unitList);
    }

    public Unit unit(int index) {
        return this.unitList.get(index);
    }

    public List<Unit> unitList(Predicate<Unit> predicate) {
        return this.unitList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Unit>(this.unitList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("scaler", new ArrayList<MetricScaler>(Collections.singletonList(this.scaler)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("AbstractMetric$Unit")) {
            this.unitList.add((Unit)node.as(Unit.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("AbstractMetric$Unit")) {
            this.unitList.remove(node.as(Unit.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("scaler")) {
            this.scaler = (MetricScaler)ObjectLoader.load(values, MetricScaler.class, (Layer)this).get(0);
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("scaler")) {
            this.scaler = (MetricScaler)values.get(0);
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public static class Unit
    extends Layer
    implements Terminal {
        protected String label;

        public Unit(Node node) {
            super(node);
        }

        public String label() {
            return this.label;
        }

        public Unit label(String value) {
            this.label = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("label")) {
                this.label = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("label")) {
                this.label = (String)values.get(0);
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public class Clear {
        public void unit(Predicate<Unit> filter) {
            new ArrayList<Unit>(AbstractMetric.this.unitList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Unit unit() {
            Unit newElement = (Unit)AbstractMetric.this.core$().graph().concept(Unit.class).createNode(this.name, AbstractMetric.this.core$()).as(Unit.class);
            return newElement;
        }

        public TemporalMetric.Unit unit(double limit, double conversionFactor) {
            TemporalMetric.Unit newElement = (TemporalMetric.Unit)AbstractMetric.this.core$().graph().concept(TemporalMetric.Unit.class).createNode(this.name, AbstractMetric.this.core$()).as(TemporalMetric.Unit.class);
            newElement.core$().set((Layer)newElement, "limit", Collections.singletonList(limit));
            newElement.core$().set((Layer)newElement, "conversionFactor", Collections.singletonList(conversionFactor));
            return newElement;
        }

        public Metric.Unit unit(Converter convert) {
            Metric.Unit newElement = (Metric.Unit)AbstractMetric.this.core$().graph().concept(Metric.Unit.class).createNode(this.name, AbstractMetric.this.core$()).as(Metric.Unit.class);
            newElement.core$().set((Layer)newElement, "convert", Collections.singletonList(convert));
            return newElement;
        }
    }
}

