/*
 * Decompiled with CFR 0.152.
 */
package io.intino.sumus.graph;

import io.intino.sumus.datawarehouse.store.Digest;
import io.intino.sumus.graph.Categorization;
import io.intino.sumus.graph.Cube;
import io.intino.sumus.graph.SumusGraph;
import io.intino.tara.magritte.Concept;
import io.intino.tara.magritte.Expression;
import io.intino.tara.magritte.Layer;
import io.intino.tara.magritte.Node;
import io.intino.tara.magritte.loaders.ConceptLoader;
import io.intino.tara.magritte.loaders.FunctionLoader;
import io.intino.tara.magritte.loaders.NodeLoader;
import io.intino.tara.magritte.loaders.StringLoader;
import io.intino.tara.magritte.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractCategorization
extends Layer
implements Terminal {
    protected String label;
    protected List<String> savedTags = new ArrayList<String>();
    protected Expression<List<String>> tags;
    protected Categorization parent;
    protected List<RecordTagger> recordTaggerList = new ArrayList<RecordTagger>();
    protected List<DigestTagger> digestTaggerList = new ArrayList<DigestTagger>();

    public AbstractCategorization(Node node) {
        super(node);
    }

    public String label() {
        return this.label;
    }

    public List<String> savedTags() {
        return this.savedTags;
    }

    public String savedTags(int index) {
        return this.savedTags.get(index);
    }

    public List<String> savedTags(Predicate<String> predicate) {
        return this.savedTags().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<String> tags() {
        return (List)this.tags.value();
    }

    public Categorization parent() {
        return this.parent;
    }

    public Categorization label(String value) {
        this.label = value;
        return (Categorization)this;
    }

    public Categorization parent(Categorization value) {
        this.parent = value;
        return (Categorization)this;
    }

    public List<RecordTagger> recordTaggerList() {
        return Collections.unmodifiableList(this.recordTaggerList);
    }

    public RecordTagger recordTagger(int index) {
        return this.recordTaggerList.get(index);
    }

    public List<RecordTagger> recordTaggerList(Predicate<RecordTagger> predicate) {
        return this.recordTaggerList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<DigestTagger> digestTaggerList() {
        return Collections.unmodifiableList(this.digestTaggerList);
    }

    public DigestTagger digestTagger(int index) {
        return this.digestTaggerList.get(index);
    }

    public List<DigestTagger> digestTaggerList(Predicate<DigestTagger> predicate) {
        return this.digestTaggerList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<RecordTagger>(this.recordTaggerList).forEach(c -> components.add(c.core$()));
        new ArrayList<DigestTagger>(this.digestTaggerList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("label", new ArrayList<String>(Collections.singletonList(this.label)));
        map.put("savedTags", this.savedTags);
        map.put("tags", this.tags != null ? new ArrayList<Expression<List<String>>>(Collections.singletonList(this.tags)) : Collections.emptyList());
        map.put("parent", this.parent != null ? new ArrayList<Categorization>(Collections.singletonList(this.parent)) : Collections.emptyList());
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Categorization$RecordTagger")) {
            this.recordTaggerList.add((RecordTagger)node.as(RecordTagger.class));
        }
        if (node.is("Categorization$DigestTagger")) {
            this.digestTaggerList.add((DigestTagger)node.as(DigestTagger.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Categorization$RecordTagger")) {
            this.recordTaggerList.remove(node.as(RecordTagger.class));
        }
        if (node.is("Categorization$DigestTagger")) {
            this.digestTaggerList.remove(node.as(DigestTagger.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("label")) {
            this.label = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("savedTags")) {
            this.savedTags = StringLoader.load(values, (Layer)this);
        } else if (name.equalsIgnoreCase("tags")) {
            this.tags = (Expression)FunctionLoader.load(values, (Layer)this, Expression.class).get(0);
        } else if (name.equalsIgnoreCase("parent")) {
            this.parent = (Categorization)((Object)NodeLoader.load(values, Categorization.class, (Layer)this).get(0));
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("label")) {
            this.label = (String)values.get(0);
        } else if (name.equalsIgnoreCase("savedTags")) {
            this.savedTags = new ArrayList(values);
        } else if (name.equalsIgnoreCase("tags")) {
            this.tags = (Expression)FunctionLoader.load(values.get(0), (Layer)this, Expression.class);
        } else if (name.equalsIgnoreCase("parent")) {
            this.parent = values.get(0) != null ? (Categorization)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Categorization.class) : null;
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public SumusGraph graph() {
        return (SumusGraph)this.core$().graph().as(SumusGraph.class);
    }

    public static class DigestTagger
    extends Layer
    implements Terminal {
        protected Cube cube;
        protected io.intino.sumus.graph.functions.DigestTagger tag;

        public DigestTagger(Node node) {
            super(node);
        }

        public Cube cube() {
            return this.cube;
        }

        public List<String> tag(Digest digest) {
            return this.tag.attributes(digest);
        }

        public DigestTagger cube(Cube value) {
            this.cube = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("cube", this.cube != null ? new ArrayList<Cube>(Collections.singletonList(this.cube)) : Collections.emptyList());
            map.put("tag", this.tag != null ? new ArrayList<io.intino.sumus.graph.functions.DigestTagger>(Collections.singletonList(this.tag)) : Collections.emptyList());
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("cube")) {
                this.cube = (Cube)((Object)NodeLoader.load(values, Cube.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("tag")) {
                this.tag = (io.intino.sumus.graph.functions.DigestTagger)FunctionLoader.load(values, (Layer)this, io.intino.sumus.graph.functions.DigestTagger.class).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("cube")) {
                this.cube = values.get(0) != null ? (Cube)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Cube.class) : null;
            } else if (name.equalsIgnoreCase("tag")) {
                this.tag = (io.intino.sumus.graph.functions.DigestTagger)FunctionLoader.load(values.get(0), (Layer)this, io.intino.sumus.graph.functions.DigestTagger.class);
            }
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }
    }

    public static class RecordTagger
    extends Layer
    implements Terminal {
        protected Concept record;
        protected io.intino.sumus.graph.functions.RecordTagger tag;

        public RecordTagger(Node node) {
            super(node);
        }

        public Concept record() {
            return this.record;
        }

        public List<String> tag(Layer item) {
            return this.tag.tags(item);
        }

        public RecordTagger record(Concept value) {
            this.record = value;
            return this;
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("record", this.record != null ? new ArrayList<Concept>(Collections.singletonList(this.record)) : Collections.emptyList());
            map.put("tag", this.tag != null ? new ArrayList<io.intino.sumus.graph.functions.RecordTagger>(Collections.singletonList(this.tag)) : Collections.emptyList());
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("record")) {
                this.record = (Concept)ConceptLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("tag")) {
                this.tag = (io.intino.sumus.graph.functions.RecordTagger)FunctionLoader.load(values, (Layer)this, io.intino.sumus.graph.functions.RecordTagger.class).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("record")) {
                this.record = (Concept)values.get(0);
            } else if (name.equalsIgnoreCase("tag")) {
                this.tag = (io.intino.sumus.graph.functions.RecordTagger)FunctionLoader.load(values.get(0), (Layer)this, io.intino.sumus.graph.functions.RecordTagger.class);
            }
        }

        public SumusGraph graph() {
            return (SumusGraph)this.core$().graph().as(SumusGraph.class);
        }
    }

    public class Clear {
        public void recordTagger(Predicate<RecordTagger> filter) {
            new ArrayList<RecordTagger>(AbstractCategorization.this.recordTaggerList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void digestTagger(Predicate<DigestTagger> filter) {
            new ArrayList<DigestTagger>(AbstractCategorization.this.digestTaggerList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public RecordTagger recordTagger(Concept record, io.intino.sumus.graph.functions.RecordTagger tag) {
            RecordTagger newElement = (RecordTagger)AbstractCategorization.this.core$().graph().concept(RecordTagger.class).createNode(this.name, AbstractCategorization.this.core$()).as(RecordTagger.class);
            newElement.core$().set((Layer)newElement, "record", Collections.singletonList(record));
            newElement.core$().set((Layer)newElement, "tag", Collections.singletonList(tag));
            return newElement;
        }

        public DigestTagger digestTagger(Cube cube, io.intino.sumus.graph.functions.DigestTagger tag) {
            DigestTagger newElement = (DigestTagger)AbstractCategorization.this.core$().graph().concept(DigestTagger.class).createNode(this.name, AbstractCategorization.this.core$()).as(DigestTagger.class);
            newElement.core$().set((Layer)newElement, "cube", Collections.singletonList(cube));
            newElement.core$().set((Layer)newElement, "tag", Collections.singletonList(tag));
            return newElement;
        }
    }
}

